/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.write;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class PointSettings {
    private static final Pattern ENV_PROPERTY = Pattern.compile("(\\$\\{env\\.)(.+)\\}");
    private static final Pattern SYSTEM_PROPERTY = Pattern.compile("(\\$\\{)(.+)(\\})");
    private final Map<String, String> defaultTags = new TreeMap<String, String>();

    @Nonnull
    public PointSettings addDefaultTag(@Nonnull String key, @Nullable String expression) {
        Arguments.checkNotNull(key, "tagName");
        this.defaultTags.put(key, expression);
        return this;
    }

    @Nonnull
    Map<String, String> getDefaultTags() {
        Function<String, String> evaluation = expression -> {
            if (expression == null) {
                return null;
            }
            Matcher matcher = ENV_PROPERTY.matcher((CharSequence)expression);
            if (matcher.matches()) {
                return System.getenv(matcher.group(2));
            }
            matcher = SYSTEM_PROPERTY.matcher((CharSequence)expression);
            if (matcher.matches()) {
                return System.getProperty(matcher.group(2));
            }
            return expression;
        };
        return this.defaultTags.entrySet().stream().map(entry -> new String[]{(String)entry.getKey(), (String)evaluation.apply((String)entry.getValue())}).filter(keyValue -> keyValue[1] != null).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1], (o, n) -> n, TreeMap::new));
    }
}

