/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.write;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.annotation.concurrent.ThreadSafe;
import it.renvins.serverpulse.velocity.libs.influxdb.client.InfluxDBClientOptions;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.WriteConsistency;
import it.renvins.serverpulse.velocity.libs.influxdb.client.domain.WritePrecision;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;

@ThreadSafe
public final class WriteParameters {
    public static final WritePrecision DEFAULT_WRITE_PRECISION = WritePrecision.NS;
    private final String bucket;
    private final String org;
    private final WritePrecision precision;
    private final WriteConsistency consistency;

    public WriteParameters(@Nullable String bucket, @Nullable String org, @Nullable WritePrecision precision, @Nullable WriteConsistency consistency) {
        this.bucket = bucket;
        this.org = org;
        this.precision = precision;
        this.consistency = consistency;
    }

    public WriteParameters(@Nullable WritePrecision precision, @Nullable WriteConsistency consistency) {
        this(null, null, precision, consistency);
    }

    public WriteParameters(@Nonnull String bucket, @Nonnull String org, @Nonnull WritePrecision precision) {
        Arguments.checkNonEmpty(bucket, "bucket");
        Arguments.checkNonEmpty(org, "org");
        Arguments.checkNotNull((Object)precision, "WritePrecision");
        this.bucket = bucket;
        this.org = org;
        this.precision = precision;
        this.consistency = null;
    }

    @Nonnull
    public String orgSafe(@Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull(options, "options");
        return this.isNotDefined(this.org) ? options.getOrg() : this.org;
    }

    @Nonnull
    public String bucketSafe(@Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull(options, "options");
        return this.isNotDefined(this.bucket) ? options.getBucket() : this.bucket;
    }

    @Nonnull
    public WritePrecision precisionSafe(@Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull(options, "options");
        return this.precision == null ? options.getPrecision() : this.precision;
    }

    @Nullable
    public WriteConsistency consistencySafe(@Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull(options, "options");
        return this.consistency == null ? options.getConsistency() : this.consistency;
    }

    public void check(@Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull(options, "options");
        if (this.isNotDefined(this.bucket) && this.isNotDefined(options.getBucket())) {
            throw new IllegalArgumentException("Expecting a non-empty string for destination bucket. Please specify the bucket as a method parameter or use default configuration at 'InfluxDBClientOptions.Bucket'.");
        }
        if (this.isNotDefined(this.org) && this.isNotDefined(options.getOrg())) {
            throw new IllegalArgumentException("Expecting a non-empty string for destination organization. Please specify the organization as a method parameter or use default configuration at 'InfluxDBClientOptions.Organization'.");
        }
    }

    @Nonnull
    public WriteParameters copy(@Nonnull WritePrecision precision, @Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull((Object)precision, "precision");
        Arguments.checkNotNull(options, "options");
        return new WriteParameters(this.bucketSafe(options), this.orgSafe(options), precision, this.consistencySafe(options));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriteParameters)) {
            return false;
        }
        WriteParameters that = (WriteParameters)o;
        if (!this.bucket.equals(that.bucket)) {
            return false;
        }
        if (!this.org.equals(that.org)) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        return this.consistency == that.consistency;
    }

    public int hashCode() {
        int result = this.bucket != null ? this.bucket.hashCode() : 0;
        result = 31 * result + (this.org != null ? this.org.hashCode() : 0);
        result = 31 * result + (this.precision != null ? this.precision.hashCode() : 0);
        result = 31 * result + (this.consistency != null ? this.consistency.hashCode() : 0);
        return result;
    }

    private boolean isNotDefined(String option) {
        return option == null || option.isEmpty();
    }
}

