/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.client.write.events;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.client.write.events.AbstractWriteEvent;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BackpressureEvent
extends AbstractWriteEvent {
    private final BackpressureReason reason;
    private static final Logger LOG = Logger.getLogger(BackpressureEvent.class.getName());

    public BackpressureEvent(@Nonnull BackpressureReason reason) {
        Arguments.checkNotNull((Object)reason, "reason");
        this.reason = reason;
    }

    @Override
    public void logEvent() {
        LOG.log(Level.WARNING, String.format("Backpressure[%s] applied, try increase WriteOptions.bufferLimit", new Object[]{this.reason}));
    }

    @Nonnull
    public BackpressureReason getReason() {
        return this.reason;
    }

    public static enum BackpressureReason {
        FAST_EMITTING,
        TOO_MUCH_BATCHES;

    }
}

