/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.LogLevel;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.BadGatewayException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.BadRequestException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.ForbiddenException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.GatewayTimeoutException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.InfluxException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.InternalServerErrorException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.MethodNotAllowedException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.NotAcceptableException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.NotFoundException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.NotImplementedException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.PaymentRequiredException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.ProxyAuthenticationRequiredException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.RequestEntityTooLargeException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.RequestTimeoutException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.ServiceUnavailableException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.UnauthorizedException;
import it.renvins.serverpulse.velocity.libs.influxdb.exceptions.UnprocessableEntityException;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.okhttp3.MediaType;
import it.renvins.serverpulse.velocity.libs.okhttp3.RequestBody;
import it.renvins.serverpulse.velocity.libs.okhttp3.ResponseBody;
import it.renvins.serverpulse.velocity.libs.okhttp3.logging.HttpLoggingInterceptor;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import it.renvins.serverpulse.velocity.libs.retrofit2.HttpException;
import it.renvins.serverpulse.velocity.libs.retrofit2.Response;
import java.io.EOFException;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRestClient {
    private static final Logger LOG = Logger.getLogger(AbstractRestClient.class.getName());
    private static final MediaType CONTENT_TYPE_JSON = MediaType.parse("application/json");

    @Nonnull
    RequestBody createBody(@Nonnull String content) {
        Arguments.checkNonEmpty(content, "content");
        return RequestBody.create(CONTENT_TYPE_JSON, content);
    }

    protected <T> T execute(@Nonnull Call<T> call) throws InfluxException {
        Arguments.checkNotNull(call, "call");
        try {
            Response<T> response = call.execute();
            if (response.isSuccessful()) {
                return response.body();
            }
            throw this.responseToError(response);
        }
        catch (IOException e) {
            throw new InfluxException(e);
        }
    }

    @Nonnull
    protected InfluxException toInfluxException(@Nonnull Throwable throwable) {
        if (throwable instanceof InfluxException) {
            return (InfluxException)throwable;
        }
        if (throwable instanceof HttpException) {
            return this.responseToError(((HttpException)throwable).response());
        }
        return new InfluxException(throwable);
    }

    @Nonnull
    protected InfluxException responseToError(@Nonnull Response<?> response) {
        Arguments.checkNotNull(response, "response");
        switch (response.code()) {
            case 400: {
                return new BadRequestException(response);
            }
            case 401: {
                return new UnauthorizedException(response);
            }
            case 402: {
                return new PaymentRequiredException(response);
            }
            case 403: {
                return new ForbiddenException(response);
            }
            case 404: {
                return new NotFoundException(response);
            }
            case 405: {
                return new MethodNotAllowedException(response);
            }
            case 406: {
                return new NotAcceptableException(response);
            }
            case 407: {
                return new ProxyAuthenticationRequiredException(response);
            }
            case 408: {
                return new RequestTimeoutException(response);
            }
            case 413: {
                return new RequestEntityTooLargeException(response);
            }
            case 422: {
                return new UnprocessableEntityException(response);
            }
            case 500: {
                return new InternalServerErrorException(response);
            }
            case 501: {
                return new NotImplementedException(response);
            }
            case 502: {
                return new BadGatewayException(response);
            }
            case 503: {
                return new ServiceUnavailableException(response);
            }
            case 504: {
                return new GatewayTimeoutException(response);
            }
        }
        return new InfluxException(response);
    }

    void catchOrPropagateException(@Nonnull Exception exception, @Nonnull Consumer<? super Throwable> onError) {
        Arguments.checkNotNull(exception, "exception");
        Arguments.checkNotNull(onError, "onError");
        if (this.isCloseException(exception)) {
            LOG.log(Level.FINEST, "Socket closed by remote server or end of data", exception);
        } else {
            onError.accept(exception);
        }
    }

    protected void setLogLevel(@Nonnull HttpLoggingInterceptor interceptor, @Nonnull LogLevel logLevel) {
        Arguments.checkNotNull((Object)logLevel, "LogLevel");
        Arguments.checkNotNull(interceptor, "HttpLogging interceptor");
        interceptor.setLevel(HttpLoggingInterceptor.Level.valueOf(logLevel.name()));
    }

    @Nonnull
    protected LogLevel getLogLevel(@Nonnull HttpLoggingInterceptor interceptor) {
        Arguments.checkNotNull(interceptor, "HttpLogging interceptor");
        return LogLevel.valueOf(interceptor.getLevel().name());
    }

    private boolean isCloseException(@Nonnull Exception exception) {
        Arguments.checkNotNull(exception, "exception");
        return exception instanceof EOFException;
    }

    @Nonnull
    protected Boolean ping(@Nonnull Call<ResponseBody> responseBody) {
        Arguments.checkNotNull(responseBody, "responseBody");
        try {
            return responseBody.execute().isSuccessful();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Ping request wasn't successful", e);
            return false;
        }
    }

    @Nonnull
    protected String version(@Nonnull Call<ResponseBody> ping) {
        try {
            String version = ping.execute().headers().get("X-Influxdb-Version");
            if (version != null) {
                return version;
            }
            return "unknown";
        }
        catch (IOException e) {
            throw new InfluxException(e);
        }
    }
}

