/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.internal;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.influxdb.utils.Arguments;
import it.renvins.serverpulse.velocity.libs.okhttp3.Interceptor;
import it.renvins.serverpulse.velocity.libs.okhttp3.Request;
import it.renvins.serverpulse.velocity.libs.okhttp3.Response;
import java.io.IOException;

public class UserAgentInterceptor
implements Interceptor {
    private final String userAgent;

    public UserAgentInterceptor(String clientType) {
        Arguments.checkNonEmpty(clientType, "clientType");
        Package mainPackage = UserAgentInterceptor.class.getPackage();
        String version = null != mainPackage ? mainPackage.getImplementationVersion() : null;
        this.userAgent = String.format("influxdb-client-%s/%s", clientType, version != null ? version : "unknown");
    }

    @Override
    @Nonnull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder().header("User-Agent", this.userAgent);
        return chain.proceed(builder.build());
    }
}

