/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.influxdb.rest;

import it.renvins.serverpulse.velocity.libs.annotation.Nonnull;
import it.renvins.serverpulse.velocity.libs.okhttp3.Call;
import it.renvins.serverpulse.velocity.libs.okhttp3.Connection;
import it.renvins.serverpulse.velocity.libs.okhttp3.EventListener;
import it.renvins.serverpulse.velocity.libs.okhttp3.Interceptor;
import it.renvins.serverpulse.velocity.libs.okhttp3.Response;
import it.renvins.serverpulse.velocity.libs.okhttp3.internal.connection.RealConnection;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public class ConnectionClosingInterceptor
extends EventListener
implements Interceptor {
    private static final Logger LOG = Logger.getLogger(ConnectionClosingInterceptor.class.getName());
    private final ConcurrentMap<Connection, Long> connectionTimes = new ConcurrentHashMap<Connection, Long>();
    private final long connectionMaxAgeMillis;

    public ConnectionClosingInterceptor(@Nonnull Duration connectionMaxAge) {
        this.connectionMaxAgeMillis = connectionMaxAge.toMillis();
    }

    @Override
    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Connection connection = chain.connection();
        if (connection != null && this.isConnectionOld(connection)) {
            if (connection instanceof RealConnection) {
                LOG.fine("Marking connection to not be reused: " + String.valueOf(connection));
                ((RealConnection)connection).noNewExchanges$okhttp();
                this.connectionTimes.remove(connection);
            } else {
                LOG.warning("Unable to mark connection to not be reused: " + String.valueOf(connection));
            }
        }
        return chain.proceed(chain.request());
    }

    @Override
    public void connectionAcquired(@Nonnull Call call, @Nonnull Connection connection) {
        this.connectionTimes.putIfAbsent(connection, System.currentTimeMillis());
    }

    private boolean isConnectionOld(@Nonnull Connection connection) {
        Long time = (Long)this.connectionTimes.get(connection);
        if (time == null) {
            return false;
        }
        long age = System.currentTimeMillis() - time;
        return age > this.connectionMaxAgeMillis;
    }
}

