/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.NonNull;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.Nullable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.DisposableContainer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.CompositeException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.ExceptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.OpenHashSet;
import java.util.ArrayList;
import java.util.Objects;

public final class CompositeDisposable
implements Disposable,
DisposableContainer {
    OpenHashSet<Disposable> resources;
    volatile boolean disposed;

    public CompositeDisposable() {
    }

    public CompositeDisposable(Disposable ... disposables) {
        Objects.requireNonNull(disposables, "disposables is null");
        this.resources = new OpenHashSet(disposables.length + 1);
        for (Disposable d : disposables) {
            Objects.requireNonNull(d, "A Disposable in the disposables array is null");
            this.resources.add(d);
        }
    }

    public CompositeDisposable(@NonNull Iterable<? extends Disposable> disposables) {
        Objects.requireNonNull(disposables, "disposables is null");
        this.resources = new OpenHashSet();
        for (Disposable disposable : disposables) {
            Objects.requireNonNull(disposable, "A Disposable item in the disposables sequence is null");
            this.resources.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@NonNull Disposable disposable) {
        Objects.requireNonNull(disposable, "disposable is null");
        if (!this.disposed) {
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new OpenHashSet();
                    }
                    set.add(disposable);
                    return true;
                }
            }
        }
        disposable.dispose();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Disposable ... disposables) {
        Objects.requireNonNull(disposables, "disposables is null");
        if (!this.disposed) {
            CompositeDisposable object = this;
            synchronized (object) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        set = new OpenHashSet(disposables.length + 1);
                        this.resources = set;
                    }
                    for (Disposable d : disposables) {
                        Objects.requireNonNull(d, "A Disposable in the disposables array is null");
                        set.add(d);
                    }
                    return true;
                }
            }
        }
        for (Disposable d : disposables) {
            d.dispose();
        }
        return false;
    }

    @Override
    public boolean remove(@NonNull Disposable disposable) {
        if (this.delete(disposable)) {
            disposable.dispose();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(@NonNull Disposable disposable) {
        Objects.requireNonNull(disposable, "disposable is null");
        if (this.disposed) {
            return false;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return false;
            }
            OpenHashSet<Disposable> set = this.resources;
            if (set == null || !set.remove(disposable)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.disposed) {
            return 0;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return 0;
            }
            OpenHashSet<Disposable> set = this.resources;
            int n = set != null ? set.size() : 0;
            return n;
        }
    }

    void dispose(@Nullable OpenHashSet<Disposable> set) {
        Object[] array;
        if (set == null) {
            return;
        }
        ArrayList<Throwable> errors = null;
        for (Object o : array = set.keys()) {
            if (!(o instanceof Disposable)) continue;
            try {
                ((Disposable)o).dispose();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (errors == null) {
                    errors = new ArrayList<Throwable>();
                }
                errors.add(ex);
            }
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw ExceptionHelper.wrapOrThrow((Throwable)errors.get(0));
            }
            throw new CompositeException((Iterable<? extends Throwable>)errors);
        }
    }
}

