/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.jdk8;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.NonNull;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.QueueOverflowException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Function;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Supplier;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.jdk8.FlowableFromStream;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.AtomicThrowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.BackpressureHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.operators.QueueSubscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.operators.SimpleQueue;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.operators.SpscArrayQueue;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public final class FlowableFlatMapStream<T, R>
extends Flowable<R> {
    final Flowable<T> source;
    final Function<? super T, ? extends Stream<? extends R>> mapper;
    final int prefetch;

    public FlowableFlatMapStream(Flowable<T> source2, Function<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
        this.source = source2;
        this.mapper = mapper;
        this.prefetch = prefetch;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        if (this.source instanceof Supplier) {
            Stream<? extends R> stream = null;
            try {
                Object t = ((Supplier)((Object)this.source)).get();
                if (t != null) {
                    stream = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Stream");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                EmptySubscription.error(ex, s);
                return;
            }
            if (stream != null) {
                FlowableFromStream.subscribeStream(s, stream);
            } else {
                EmptySubscription.complete(s);
            }
        } else {
            this.source.subscribe(FlowableFlatMapStream.subscribe(s, this.mapper, this.prefetch));
        }
    }

    public static <T, R> Subscriber<T> subscribe(Subscriber<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
        return new FlatMapStreamSubscriber<T, R>(downstream, mapper, prefetch);
    }

    static final class FlatMapStreamSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5127032662980523968L;
        final Subscriber<? super R> downstream;
        final Function<? super T, ? extends Stream<? extends R>> mapper;
        final int prefetch;
        final AtomicLong requested;
        SimpleQueue<T> queue;
        Subscription upstream;
        Iterator<? extends R> currentIterator;
        AutoCloseable currentCloseable;
        volatile boolean cancelled;
        volatile boolean upstreamDone;
        final AtomicThrowable error;
        long emitted;
        int consumed;
        int sourceMode;

        FlatMapStreamSubscriber(Subscriber<? super R> downstream, Function<? super T, ? extends Stream<? extends R>> mapper, int prefetch) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.requested = new AtomicLong();
            this.error = new AtomicThrowable();
        }

        @Override
        public void onSubscribe(@NonNull Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.upstreamDone = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.downstream.onSubscribe(this);
                        s.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.downstream.onSubscribe(this);
                s.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode != 2 && !this.queue.offer(t)) {
                this.upstream.cancel();
                this.onError(new QueueOverflowException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.error.compareAndSet(null, t)) {
                this.upstreamDone = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.upstream.cancel();
            this.drain();
        }

        void drain() {
            boolean canRequest;
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> downstream = this.downstream;
            SimpleQueue<T> queue = this.queue;
            AtomicThrowable error = this.error;
            Iterator<Object> iterator2 = this.currentIterator;
            long requested = this.requested.get();
            long emitted = this.emitted;
            int limit = this.prefetch - (this.prefetch >> 2);
            boolean bl = canRequest = this.sourceMode != 1;
            while (true) {
                if (this.cancelled) {
                    queue.clear();
                    this.clearCurrentSuppressCloseError();
                } else {
                    boolean isDone = this.upstreamDone;
                    if (error.get() != null) {
                        downstream.onError((Throwable)error.get());
                        this.cancelled = true;
                        continue;
                    }
                    if (iterator2 == null) {
                        boolean isEmpty;
                        T t;
                        try {
                            t = queue.poll();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.trySignalError(downstream, ex);
                            continue;
                        }
                        boolean bl2 = isEmpty = t == null;
                        if (isDone && isEmpty) {
                            downstream.onComplete();
                            this.cancelled = true;
                        } else if (!isEmpty) {
                            if (canRequest && ++this.consumed == limit) {
                                this.consumed = 0;
                                this.upstream.request(limit);
                            }
                            try {
                                Stream<R> stream = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Stream");
                                iterator2 = stream.iterator();
                                if (iterator2.hasNext()) {
                                    this.currentIterator = iterator2;
                                    this.currentCloseable = stream;
                                    continue;
                                }
                                iterator2 = null;
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                this.trySignalError(downstream, ex);
                            }
                            continue;
                        }
                    }
                    if (iterator2 != null && emitted != requested) {
                        R item;
                        try {
                            item = Objects.requireNonNull(iterator2.next(), "The Stream.Iterator returned a null value");
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.trySignalError(downstream, ex);
                            continue;
                        }
                        if (this.cancelled) continue;
                        downstream.onNext(item);
                        ++emitted;
                        if (this.cancelled) continue;
                        try {
                            if (iterator2.hasNext()) continue;
                            iterator2 = null;
                            this.clearCurrentRethrowCloseError();
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.trySignalError(downstream, ex);
                        }
                        continue;
                    }
                }
                this.emitted = emitted;
                missed = this.addAndGet(-missed);
                if (missed == 0) break;
                requested = this.requested.get();
            }
        }

        void clearCurrentRethrowCloseError() throws Throwable {
            this.currentIterator = null;
            AutoCloseable ac = this.currentCloseable;
            this.currentCloseable = null;
            if (ac != null) {
                ac.close();
            }
        }

        void clearCurrentSuppressCloseError() {
            try {
                this.clearCurrentRethrowCloseError();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        void trySignalError(Subscriber<?> downstream, Throwable ex) {
            if (this.error.compareAndSet(null, ex)) {
                this.upstream.cancel();
                this.cancelled = true;
                downstream.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

