/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.jdk8;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.NonNull;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;

abstract class FlowableStageSubscriber<T>
extends CompletableFuture<T>
implements FlowableSubscriber<T> {
    final AtomicReference<Subscription> upstream = new AtomicReference();
    T value;

    FlowableStageSubscriber() {
    }

    @Override
    public final void onSubscribe(@NonNull Subscription s) {
        if (SubscriptionHelper.setOnce(this.upstream, s)) {
            this.afterSubscribe(s);
        }
    }

    protected abstract void afterSubscribe(Subscription var1);

    @Override
    public final void onError(Throwable t) {
        this.clear();
        if (!this.completeExceptionally(t)) {
            RxJavaPlugins.onError(t);
        }
    }

    protected final void cancelUpstream() {
        SubscriptionHelper.cancel(this.upstream);
    }

    protected final void clear() {
        this.value = null;
        this.upstream.lazySet(SubscriptionHelper.CANCELLED);
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelUpstream();
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public final boolean complete(T value) {
        this.cancelUpstream();
        return super.complete(value);
    }

    @Override
    public final boolean completeExceptionally(Throwable ex) {
        this.cancelUpstream();
        return super.completeExceptionally(ex);
    }
}

