/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.completable;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Completable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableAndThenCompletable
extends Completable {
    final CompletableSource source;
    final CompletableSource next;

    public CompletableAndThenCompletable(CompletableSource source2, CompletableSource next) {
        this.source = source2;
        this.next = next;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new SourceObserver(observer, this.next));
    }

    static final class NextObserver
    implements CompletableObserver {
        final AtomicReference<Disposable> parent;
        final CompletableObserver downstream;

        NextObserver(AtomicReference<Disposable> parent, CompletableObserver downstream) {
            this.parent = parent;
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.replace(this.parent, d);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }

    static final class SourceObserver
    extends AtomicReference<Disposable>
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = -4101678820158072998L;
        final CompletableObserver actualObserver;
        final CompletableSource next;

        SourceObserver(CompletableObserver actualObserver, CompletableSource next) {
            this.actualObserver = actualObserver;
            this.next = next;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this, d)) {
                this.actualObserver.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.actualObserver.onError(e);
        }

        @Override
        public void onComplete() {
            this.next.subscribe(new NextObserver(this, this.actualObserver));
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }
    }
}

