/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.completable;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Completable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableDelay
extends Completable {
    final CompletableSource source;
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public CompletableDelay(CompletableSource source2, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        this.source = source2;
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new Delay(observer, this.delay, this.unit, this.scheduler, this.delayError));
    }

    static final class Delay
    extends AtomicReference<Disposable>
    implements CompletableObserver,
    Runnable,
    Disposable {
        private static final long serialVersionUID = 465972761105851022L;
        final CompletableObserver downstream;
        final long delay;
        final TimeUnit unit;
        final Scheduler scheduler;
        final boolean delayError;
        Throwable error;

        Delay(CompletableObserver downstream, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
            this.downstream = downstream;
            this.delay = delay;
            this.unit = unit;
            this.scheduler = scheduler;
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this, d)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onComplete() {
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this, this.delay, this.unit));
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this, this.delayError ? this.delay : 0L, this.unit));
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void run() {
            Throwable e = this.error;
            this.error = null;
            if (e != null) {
                this.downstream.onError(e);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

