/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.completable;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Completable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.CompositeException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Predicate;

public final class CompletableOnErrorComplete
extends Completable {
    final CompletableSource source;
    final Predicate<? super Throwable> predicate;

    public CompletableOnErrorComplete(CompletableSource source2, Predicate<? super Throwable> predicate) {
        this.source = source2;
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new OnError(observer, this.predicate));
    }

    static final class OnError
    implements CompletableObserver {
        private final CompletableObserver downstream;
        private final Predicate<? super Throwable> predicate;

        OnError(CompletableObserver observer, Predicate<? super Throwable> predicate) {
            this.downstream = observer;
            this.predicate = predicate;
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            boolean b;
            try {
                b = this.predicate.test(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(e, ex));
                return;
            }
            if (b) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(e);
            }
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.downstream.onSubscribe(d);
        }
    }
}

