/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.completable;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Completable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableTimer
extends Completable {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;

    public CompletableTimer(long delay, TimeUnit unit, Scheduler scheduler) {
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        TimerDisposable parent = new TimerDisposable(observer);
        observer.onSubscribe(parent);
        parent.setFuture(this.scheduler.scheduleDirect(parent, this.delay, this.unit));
    }

    static final class TimerDisposable
    extends AtomicReference<Disposable>
    implements Disposable,
    Runnable {
        private static final long serialVersionUID = 3167244060586201109L;
        final CompletableObserver downstream;

        TimerDisposable(CompletableObserver downstream) {
            this.downstream = downstream;
        }

        @Override
        public void run() {
            this.downstream.onComplete();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        void setFuture(Disposable d) {
            DisposableHelper.replace(this, d);
        }
    }
}

