/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.Nullable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.CompositeException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Action;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Consumer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.ExceptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.operators.ConditionalSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class FlowableDoOnEach<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    final Action onAfterTerminate;

    public FlowableDoOnEach(Flowable<T> source2, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
        super(source2);
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
        this.onAfterTerminate = onAfterTerminate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new DoOnEachConditionalSubscriber<T>((ConditionalSubscriber)s, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        } else {
            this.source.subscribe(new DoOnEachSubscriber<T>(s, this.onNext, this.onError, this.onComplete, this.onAfterTerminate));
        }
    }

    static final class DoOnEachConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachConditionalSubscriber(ConditionalSubscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.downstream.onNext(t);
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                return false;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return false;
            }
            return this.downstream.tryOnNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t, e));
                relay = false;
            }
            if (relay) {
                this.downstream.onError(t);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.downstream.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            block13: {
                try {
                    v = this.qs.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    try {
                        this.onError.accept(ex);
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        throw new CompositeException(ex, exc);
                    }
                    throw ExceptionHelper.throwIfThrowable(ex);
                }
                if (v != null) {
                    try {
                        try {
                            this.onNext.accept(v);
                            break block13;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            try {
                                this.onError.accept(ex);
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                throw new CompositeException(ex, exc);
                            }
                            throw ExceptionHelper.throwIfThrowable(ex);
                        }
                    }
                    finally {
                        this.onAfterTerminate.run();
                    }
                }
                if (this.sourceMode == 1) {
                    this.onComplete.run();
                    this.onAfterTerminate.run();
                }
            }
            return v;
        }
    }

    static final class DoOnEachSubscriber<T>
    extends BasicFuseableSubscriber<T, T> {
        final Consumer<? super T> onNext;
        final Consumer<? super Throwable> onError;
        final Action onComplete;
        final Action onAfterTerminate;

        DoOnEachSubscriber(Subscriber<? super T> actual, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, Action onAfterTerminate) {
            super(actual);
            this.onNext = onNext;
            this.onError = onError;
            this.onComplete = onComplete;
            this.onAfterTerminate = onAfterTerminate;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                this.onNext.accept(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            boolean relay = true;
            try {
                this.onError.accept(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t, e));
                relay = false;
            }
            if (relay) {
                this.downstream.onError(t);
            }
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            try {
                this.onComplete.run();
            }
            catch (Throwable e) {
                this.fail(e);
                return;
            }
            this.done = true;
            this.downstream.onComplete();
            try {
                this.onAfterTerminate.run();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            block13: {
                try {
                    v = this.qs.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    try {
                        this.onError.accept(ex);
                    }
                    catch (Throwable exc) {
                        Exceptions.throwIfFatal(exc);
                        throw new CompositeException(ex, exc);
                    }
                    throw ExceptionHelper.throwIfThrowable(ex);
                }
                if (v != null) {
                    try {
                        try {
                            this.onNext.accept(v);
                            break block13;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            try {
                                this.onError.accept(ex);
                            }
                            catch (Throwable exc) {
                                Exceptions.throwIfFatal(exc);
                                throw new CompositeException(ex, exc);
                            }
                            throw ExceptionHelper.throwIfThrowable(ex);
                        }
                    }
                    finally {
                        this.onAfterTerminate.run();
                    }
                }
                if (this.sourceMode == 1) {
                    this.onComplete.run();
                    this.onAfterTerminate.run();
                }
            }
            return v;
        }
    }
}

