/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Consumer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable.AbstractBackpressureThrottlingSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;

public final class FlowableOnBackpressureLatest<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Consumer<? super T> onDropped;

    public FlowableOnBackpressureLatest(Flowable<T> source2, Consumer<? super T> onDropped) {
        super(source2);
        this.onDropped = onDropped;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new BackpressureLatestSubscriber<T>(s, this.onDropped));
    }

    static final class BackpressureLatestSubscriber<T>
    extends AbstractBackpressureThrottlingSubscriber<T, T> {
        private static final long serialVersionUID = 163080509307634843L;
        final Consumer<? super T> onDropped;

        BackpressureLatestSubscriber(Subscriber<? super T> downstream, Consumer<? super T> onDropped) {
            super(downstream);
            this.onDropped = onDropped;
        }

        @Override
        public void onNext(T t) {
            T oldValue = this.current.getAndSet(t);
            if (this.onDropped != null && oldValue != null) {
                try {
                    this.onDropped.accept(oldValue);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.cancel();
                    this.downstream.onError(ex);
                }
            }
            this.drain();
        }
    }
}

