/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.CompositeException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Predicate;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;

public final class FlowableOnErrorComplete<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super Throwable> predicate;

    public FlowableOnErrorComplete(Flowable<T> source2, Predicate<? super Throwable> predicate) {
        super(source2);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> observer) {
        this.source.subscribe(new OnErrorCompleteSubscriber<T>(observer, this.predicate));
    }

    public static final class OnErrorCompleteSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final Predicate<? super Throwable> predicate;
        Subscription upstream;

        public OnErrorCompleteSubscriber(Subscriber<? super T> actual, Predicate<? super Throwable> predicate) {
            this.downstream = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        @Override
        public void onError(Throwable e) {
            boolean b;
            try {
                b = this.predicate.test(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(e, ex));
                return;
            }
            if (b) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }
    }
}

