/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Publisher;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Maybe;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.MaybeObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.BiFunction;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.fuseable.FuseToFlowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.fuseable.HasUpstreamPublisher;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable.FlowableReduce;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;

public final class FlowableReduceMaybe<T>
extends Maybe<T>
implements HasUpstreamPublisher<T>,
FuseToFlowable<T> {
    final Flowable<T> source;
    final BiFunction<T, T, T> reducer;

    public FlowableReduceMaybe(Flowable<T> source2, BiFunction<T, T, T> reducer) {
        this.source = source2;
        this.reducer = reducer;
    }

    @Override
    public Publisher<T> source() {
        return this.source;
    }

    @Override
    public Flowable<T> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableReduce<T>(this.source, this.reducer));
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe((FlowableSubscriber<? super T>)new ReduceSubscriber<T>(observer, this.reducer));
    }

    static final class ReduceSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final BiFunction<T, T, T> reducer;
        T value;
        Subscription upstream;
        boolean done;

        ReduceSubscriber(MaybeObserver<? super T> actual, BiFunction<T, T, T> reducer) {
            this.downstream = actual;
            this.reducer = reducer;
        }

        @Override
        public void dispose() {
            this.upstream.cancel();
            this.done = true;
        }

        @Override
        public boolean isDisposed() {
            return this.done;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            T v = this.value;
            if (v == null) {
                this.value = t;
            } else {
                try {
                    this.value = Objects.requireNonNull(this.reducer.apply(v, t), "The reducer returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.cancel();
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v = this.value;
            if (v != null) {
                this.downstream.onSuccess(v);
            } else {
                this.downstream.onComplete();
            }
        }
    }
}

