/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Publisher;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Single;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.SingleObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.BiFunction;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Supplier;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable.FlowableReduceSeedSingle;
import java.util.Objects;

public final class FlowableReduceWithSingle<T, R>
extends Single<R> {
    final Publisher<T> source;
    final Supplier<R> seedSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public FlowableReduceWithSingle(Publisher<T> source2, Supplier<R> seedSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source2;
        this.seedSupplier = seedSupplier;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        R seed;
        try {
            seed = Objects.requireNonNull(this.seedSupplier.get(), "The seedSupplier returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.source.subscribe(new FlowableReduceSeedSingle.ReduceSeedObserver<T, R>(observer, this.reducer, seed));
    }
}

