/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Publisher;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.CompositeException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.BiPredicate;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import java.util.concurrent.atomic.AtomicInteger;

public final class FlowableRetryBiPredicate<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiPredicate<? super Integer, ? super Throwable> predicate;

    public FlowableRetryBiPredicate(Flowable<T> source2, BiPredicate<? super Integer, ? super Throwable> predicate) {
        super(source2);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        SubscriptionArbiter sa = new SubscriptionArbiter(false);
        s.onSubscribe(sa);
        RetryBiSubscriber<T> rs = new RetryBiSubscriber<T>(s, this.predicate, sa, this.source);
        rs.subscribeNext();
    }

    static final class RetryBiSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Subscriber<? super T> downstream;
        final SubscriptionArbiter sa;
        final Publisher<? extends T> source;
        final BiPredicate<? super Integer, ? super Throwable> predicate;
        int retries;
        long produced;

        RetryBiSubscriber(Subscriber<? super T> actual, BiPredicate<? super Integer, ? super Throwable> predicate, SubscriptionArbiter sa, Publisher<? extends T> source2) {
            this.downstream = actual;
            this.sa = sa;
            this.source = source2;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.sa.setSubscription(s);
        }

        @Override
        public void onNext(T t) {
            ++this.produced;
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test((Integer)(++this.retries), t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(new CompositeException(t, e));
                return;
            }
            if (!b) {
                this.downstream.onError(t);
                return;
            }
            this.subscribeNext();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        void subscribeNext() {
            block3: {
                if (this.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.sa.isCancelled()) {
                        return;
                    }
                    long p = this.produced;
                    if (p != 0L) {
                        this.produced = 0L;
                        this.sa.produced(p);
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

