/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.maybe;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.MaybeObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.MaybeSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.maybe.AbstractMaybeWithUpstream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeDelay<T>
extends AbstractMaybeWithUpstream<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public MaybeDelay(MaybeSource<T> source2, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        super(source2);
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new DelayMaybeObserver<T>(observer, this.delay, this.unit, this.scheduler, this.delayError));
    }

    static final class DelayMaybeObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 5566860102500855068L;
        final MaybeObserver<? super T> downstream;
        final long delay;
        final TimeUnit unit;
        final Scheduler scheduler;
        final boolean delayError;
        T value;
        Throwable error;

        DelayMaybeObserver(MaybeObserver<? super T> actual, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
            this.downstream = actual;
            this.delay = delay;
            this.unit = unit;
            this.scheduler = scheduler;
            this.delayError = delayError;
        }

        @Override
        public void run() {
            Throwable ex = this.error;
            if (ex != null) {
                this.downstream.onError(ex);
            } else {
                T v = this.value;
                if (v != null) {
                    this.downstream.onSuccess(v);
                } else {
                    this.downstream.onComplete();
                }
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.setOnce(this, d)) {
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.schedule(this.delay);
        }

        @Override
        public void onError(Throwable e) {
            this.error = e;
            this.schedule(this.delayError ? this.delay : 0L);
        }

        @Override
        public void onComplete() {
            this.schedule(this.delay);
        }

        void schedule(long delay) {
            DisposableHelper.replace(this, this.scheduler.scheduleDirect(this, delay, this.unit));
        }
    }
}

