/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.maybe;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.MaybeObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.MaybeSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Single;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.SingleObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.BiPredicate;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeEqualSingle<T>
extends Single<Boolean> {
    final MaybeSource<? extends T> source1;
    final MaybeSource<? extends T> source2;
    final BiPredicate<? super T, ? super T> isEqual;

    public MaybeEqualSingle(MaybeSource<? extends T> source1, MaybeSource<? extends T> source2, BiPredicate<? super T, ? super T> isEqual) {
        this.source1 = source1;
        this.source2 = source2;
        this.isEqual = isEqual;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> observer) {
        EqualCoordinator<? extends T> parent = new EqualCoordinator<T>(observer, this.isEqual);
        observer.onSubscribe(parent);
        parent.subscribe(this.source1, this.source2);
    }

    static final class EqualObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = -3031974433025990931L;
        final EqualCoordinator<T> parent;
        Object value;

        EqualObserver(EqualCoordinator<T> parent) {
            this.parent = parent;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onSuccess(T value) {
            this.value = value;
            this.parent.done();
        }

        @Override
        public void onError(Throwable e) {
            this.parent.error(this, e);
        }

        @Override
        public void onComplete() {
            this.parent.done();
        }
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Disposable {
        final SingleObserver<? super Boolean> downstream;
        final EqualObserver<T> observer1;
        final EqualObserver<T> observer2;
        final BiPredicate<? super T, ? super T> isEqual;

        EqualCoordinator(SingleObserver<? super Boolean> actual, BiPredicate<? super T, ? super T> isEqual) {
            super(2);
            this.downstream = actual;
            this.isEqual = isEqual;
            this.observer1 = new EqualObserver(this);
            this.observer2 = new EqualObserver(this);
        }

        void subscribe(MaybeSource<? extends T> source1, MaybeSource<? extends T> source2) {
            source1.subscribe(this.observer1);
            source2.subscribe(this.observer2);
        }

        @Override
        public void dispose() {
            this.observer1.dispose();
            this.observer2.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.observer1.get());
        }

        void done() {
            if (this.decrementAndGet() == 0) {
                Object o1 = this.observer1.value;
                Object o2 = this.observer2.value;
                if (o1 != null && o2 != null) {
                    boolean b;
                    try {
                        b = this.isEqual.test(o1, o2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                    this.downstream.onSuccess((Boolean)b);
                } else {
                    this.downstream.onSuccess((Boolean)(o1 == null && o2 == null ? 1 : 0));
                }
            }
        }

        void error(EqualObserver<T> sender, Throwable ex) {
            if (this.getAndSet(0) > 0) {
                if (sender == this.observer1) {
                    this.observer2.dispose();
                } else {
                    this.observer1.dispose();
                }
                this.downstream.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

