/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.mixed;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.CompletableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.ObservableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;

public final class CompletableAndThenObservable<R>
extends Observable<R> {
    final CompletableSource source;
    final ObservableSource<? extends R> other;

    public CompletableAndThenObservable(CompletableSource source2, ObservableSource<? extends R> other) {
        this.source = source2;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        AndThenObservableObserver<? extends R> parent = new AndThenObservableObserver<R>(observer, this.other);
        observer.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class AndThenObservableObserver<R>
    extends AtomicReference<Disposable>
    implements Observer<R>,
    CompletableObserver,
    Disposable {
        private static final long serialVersionUID = -8948264376121066672L;
        final Observer<? super R> downstream;
        ObservableSource<? extends R> other;

        AndThenObservableObserver(Observer<? super R> downstream, ObservableSource<? extends R> other) {
            this.other = other;
            this.downstream = downstream;
        }

        @Override
        public void onNext(R t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            ObservableSource<R> o = this.other;
            if (o == null) {
                this.downstream.onComplete();
            } else {
                this.other = null;
                o.subscribe(this);
            }
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.replace(this, d);
        }
    }
}

