/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.observable;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.Nullable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.ObservableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Predicate;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.observers.BasicFuseableObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableFilter<T>
extends AbstractObservableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public ObservableFilter(ObservableSource<T> source2, Predicate<? super T> predicate) {
        super(source2);
        this.predicate = predicate;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new FilterObserver<T>(observer, this.predicate));
    }

    static final class FilterObserver<T>
    extends BasicFuseableObserver<T, T> {
        final Predicate<? super T> filter;

        FilterObserver(Observer<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode == 0) {
                boolean b;
                try {
                    b = this.filter.test(t);
                }
                catch (Throwable e) {
                    this.fail(e);
                    return;
                }
                if (b) {
                    this.downstream.onNext(t);
                }
            } else {
                this.downstream.onNext(null);
            }
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qd.poll()) != null && !this.filter.test(v)) {
            }
            return v;
        }
    }
}

