/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.observable;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Maybe;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.MaybeObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.ObservableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableSingleMaybe<T>
extends Maybe<T> {
    final ObservableSource<T> source;

    public ObservableSingleMaybe(ObservableSource<T> source2) {
        this.source = source2;
    }

    @Override
    public void subscribeActual(MaybeObserver<? super T> t) {
        this.source.subscribe(new SingleElementObserver<T>(t));
    }

    static final class SingleElementObserver<T>
    implements Observer<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        Disposable upstream;
        T value;
        boolean done;

        SingleElementObserver(MaybeObserver<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.value != null) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onError(new IllegalArgumentException("Sequence contains more than one element!"));
                return;
            }
            this.value = t;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v = this.value;
            this.value = null;
            if (v == null) {
                this.downstream.onComplete();
            } else {
                this.downstream.onSuccess(v);
            }
        }
    }
}

