/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.observable;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.ObservableSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Consumer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.observers.SerializedObserver;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableThrottleFirstTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Consumer<? super T> onDropped;

    public ObservableThrottleFirstTimed(ObservableSource<T> source2, long timeout2, TimeUnit unit, Scheduler scheduler, Consumer<? super T> onDropped) {
        super(source2);
        this.timeout = timeout2;
        this.unit = unit;
        this.scheduler = scheduler;
        this.onDropped = onDropped;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new DebounceTimedObserver<T>(new SerializedObserver<T>(t), this.timeout, this.unit, this.scheduler.createWorker(), this.onDropped));
    }

    static final class DebounceTimedObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 786994795061867455L;
        final Observer<? super T> downstream;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Consumer<? super T> onDropped;
        Disposable upstream;
        volatile boolean gate;

        DebounceTimedObserver(Observer<? super T> actual, long timeout2, TimeUnit unit, Scheduler.Worker worker, Consumer<? super T> onDropped) {
            this.downstream = actual;
            this.timeout = timeout2;
            this.unit = unit;
            this.worker = worker;
            this.onDropped = onDropped;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.gate) {
                this.gate = true;
                this.downstream.onNext(t);
                Disposable d = (Disposable)this.get();
                if (d != null) {
                    d.dispose();
                }
                DisposableHelper.replace(this, this.worker.schedule(this, this.timeout, this.unit));
            } else if (this.onDropped != null) {
                try {
                    this.onDropped.accept(t);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.upstream.dispose();
                    this.downstream.onError(ex);
                    this.worker.dispose();
                }
            }
        }

        @Override
        public void run() {
            this.gate = false;
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
            this.worker.dispose();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }
    }
}

