/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.parallel;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.BackpressureHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.parallel.ParallelFlowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ParallelSortedJoin<T>
extends Flowable<T> {
    final ParallelFlowable<List<T>> source;
    final Comparator<? super T> comparator;

    public ParallelSortedJoin(ParallelFlowable<List<T>> source2, Comparator<? super T> comparator) {
        this.source = source2;
        this.comparator = comparator;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        SortedJoinSubscription<? super T> parent = new SortedJoinSubscription<T>(s, this.source.parallelism(), this.comparator);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SortedJoinInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<List<T>> {
        private static final long serialVersionUID = 6751017204873808094L;
        final SortedJoinSubscription<T> parent;
        final int index;

        SortedJoinInnerSubscriber(SortedJoinSubscription<T> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.setOnce(this, s, Long.MAX_VALUE);
        }

        @Override
        public void onNext(List<T> t) {
            this.parent.innerNext(t, this.index);
        }

        @Override
        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        @Override
        public void onComplete() {
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class SortedJoinSubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 3481980673745556697L;
        final Subscriber<? super T> downstream;
        final SortedJoinInnerSubscriber<T>[] subscribers;
        final List<T>[] lists;
        final int[] indexes;
        final Comparator<? super T> comparator;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicReference<Throwable> error = new AtomicReference();

        SortedJoinSubscription(Subscriber<? super T> actual, int n, Comparator<? super T> comparator) {
            this.downstream = actual;
            this.comparator = comparator;
            SortedJoinInnerSubscriber[] s = new SortedJoinInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                s[i] = new SortedJoinInnerSubscriber(this, i);
            }
            this.subscribers = s;
            this.lists = new List[n];
            this.indexes = new int[n];
            this.remaining.lazySet(n);
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                if (this.remaining.get() == 0) {
                    this.drain();
                }
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    Arrays.fill(this.lists, null);
                }
            }
        }

        void cancelAll() {
            for (SortedJoinInnerSubscriber<T> s : this.subscribers) {
                s.cancel();
            }
        }

        void innerNext(List<T> value, int index) {
            this.lists[index] = value;
            if (this.remaining.decrementAndGet() == 0) {
                this.drain();
            }
        }

        void innerError(Throwable e) {
            if (this.error.compareAndSet(null, e)) {
                this.drain();
            } else if (e != this.error.get()) {
                RxJavaPlugins.onError(e);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<T> a = this.downstream;
            Object[] lists = this.lists;
            int[] indexes = this.indexes;
            int n = indexes.length;
            do {
                Throwable ex;
                long e;
                long r = this.requested.get();
                for (e = 0L; e != r; ++e) {
                    if (this.cancelled) {
                        Arrays.fill(lists, null);
                        return;
                    }
                    ex = this.error.get();
                    if (ex != null) {
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        a.onError(ex);
                        return;
                    }
                    Object min = null;
                    int minIndex = -1;
                    for (int i = 0; i < n; ++i) {
                        boolean smaller;
                        Object list = lists[i];
                        int index = indexes[i];
                        if (list.size() == index) continue;
                        if (min == null) {
                            min = list.get(index);
                            minIndex = i;
                            continue;
                        }
                        Object b = list.get(index);
                        try {
                            smaller = this.comparator.compare(min, b) > 0;
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAll();
                            Arrays.fill(lists, null);
                            if (!this.error.compareAndSet(null, exc)) {
                                RxJavaPlugins.onError(exc);
                            }
                            a.onError(this.error.get());
                            return;
                        }
                        if (!smaller) continue;
                        min = b;
                        minIndex = i;
                    }
                    if (min == null) {
                        Arrays.fill(lists, null);
                        a.onComplete();
                        return;
                    }
                    a.onNext(min);
                    int n2 = minIndex;
                    indexes[n2] = indexes[n2] + 1;
                }
                if (this.cancelled) {
                    Arrays.fill(lists, null);
                    return;
                }
                ex = this.error.get();
                if (ex != null) {
                    this.cancelAll();
                    Arrays.fill(lists, null);
                    a.onError(ex);
                    return;
                }
                boolean empty = true;
                for (int i = 0; i < n; ++i) {
                    if (indexes[i] == lists[i].size()) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    Arrays.fill(lists, null);
                    a.onComplete();
                    return;
                }
                if (e == 0L) continue;
                BackpressureHelper.produced(this.requested, e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

