/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.single;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Single;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.SingleObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.SingleSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleSubscribeOn<T>
extends Single<T> {
    final SingleSource<? extends T> source;
    final Scheduler scheduler;

    public SingleSubscribeOn(SingleSource<? extends T> source2, Scheduler scheduler) {
        this.source = source2;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        SubscribeOnObserver<? extends T> parent = new SubscribeOnObserver<T>(observer, this.source);
        observer.onSubscribe(parent);
        Disposable f = this.scheduler.scheduleDirect(parent);
        parent.task.replace(f);
    }

    static final class SubscribeOnObserver<T>
    extends AtomicReference<Disposable>
    implements SingleObserver<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 7000911171163930287L;
        final SingleObserver<? super T> downstream;
        final SequentialDisposable task;
        final SingleSource<? extends T> source;

        SubscribeOnObserver(SingleObserver<? super T> actual, SingleSource<? extends T> source2) {
            this.downstream = actual;
            this.source = source2;
            this.task = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce(this, d);
        }

        @Override
        public void onSuccess(T value) {
            this.downstream.onSuccess(value);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
            this.task.dispose();
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void run() {
            this.source.subscribe(this);
        }
    }
}

