/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.operators.single;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Single;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.SingleObserver;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.SingleSource;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.CompositeException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Consumer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Function;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Supplier;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.DisposableHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class SingleUsing<T, U>
extends Single<T> {
    final Supplier<U> resourceSupplier;
    final Function<? super U, ? extends SingleSource<? extends T>> singleFunction;
    final Consumer<? super U> disposer;
    final boolean eager;

    public SingleUsing(Supplier<U> resourceSupplier, Function<? super U, ? extends SingleSource<? extends T>> singleFunction, Consumer<? super U> disposer, boolean eager) {
        this.resourceSupplier = resourceSupplier;
        this.singleFunction = singleFunction;
        this.disposer = disposer;
        this.eager = eager;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        SingleSource<T> source2;
        U resource;
        try {
            resource = this.resourceSupplier.get();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        try {
            source2 = Objects.requireNonNull(this.singleFunction.apply(resource), "The singleFunction returned a null SingleSource");
        }
        catch (Throwable ex2) {
            CompositeException ex2;
            Exceptions.throwIfFatal(ex2);
            if (this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    ex2 = new CompositeException(ex2, exc);
                }
            }
            EmptyDisposable.error((Throwable)ex2, observer);
            if (!this.eager) {
                try {
                    this.disposer.accept(resource);
                }
                catch (Throwable exc) {
                    Exceptions.throwIfFatal(exc);
                    RxJavaPlugins.onError(exc);
                }
            }
            return;
        }
        source2.subscribe(new UsingSingleObserver<T, U>(observer, resource, this.eager, this.disposer));
    }

    static final class UsingSingleObserver<T, U>
    extends AtomicReference<Object>
    implements SingleObserver<T>,
    Disposable {
        private static final long serialVersionUID = -5331524057054083935L;
        final SingleObserver<? super T> downstream;
        final Consumer<? super U> disposer;
        final boolean eager;
        Disposable upstream;

        UsingSingleObserver(SingleObserver<? super T> actual, U resource, boolean eager, Consumer<? super U> disposer) {
            super(resource);
            this.downstream = actual;
            this.eager = eager;
            this.disposer = disposer;
        }

        @Override
        public void dispose() {
            if (this.eager) {
                this.disposeResource();
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
            } else {
                this.upstream.dispose();
                this.upstream = DisposableHelper.DISPOSED;
                this.disposeResource();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u = this.getAndSet(this);
                if (u != this) {
                    try {
                        this.disposer.accept(u);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.downstream.onError(ex);
                        return;
                    }
                } else {
                    return;
                }
            }
            this.downstream.onSuccess(value);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.upstream = DisposableHelper.DISPOSED;
            if (this.eager) {
                UsingSingleObserver u = this.getAndSet(this);
                if (u != this) {
                    try {
                        this.disposer.accept(u);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        e = new CompositeException(e, ex);
                    }
                } else {
                    return;
                }
            }
            this.downstream.onError(e);
            if (!this.eager) {
                this.disposeResource();
            }
        }

        void disposeResource() {
            UsingSingleObserver u = this.getAndSet(this);
            if (u != this) {
                try {
                    this.disposer.accept(u);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

