/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.schedulers;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.functions.Functions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.schedulers.SchedulerRunnableIntrospection;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;

abstract class AbstractDirectTask
extends AtomicReference<Future<?>>
implements Disposable,
SchedulerRunnableIntrospection {
    private static final long serialVersionUID = 1811839108042568751L;
    protected final Runnable runnable;
    protected final boolean interruptOnCancel;
    protected Thread runner;
    protected static final FutureTask<Void> FINISHED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);
    protected static final FutureTask<Void> DISPOSED = new FutureTask<Object>(Functions.EMPTY_RUNNABLE, null);

    AbstractDirectTask(Runnable runnable2, boolean interruptOnCancel) {
        this.runnable = runnable2;
        this.interruptOnCancel = interruptOnCancel;
    }

    @Override
    public final void dispose() {
        Future f = (Future)this.get();
        if (f != FINISHED && f != DISPOSED && this.compareAndSet(f, DISPOSED) && f != null) {
            this.cancelFuture(f);
        }
    }

    @Override
    public final boolean isDisposed() {
        Future f = (Future)this.get();
        return f == FINISHED || f == DISPOSED;
    }

    public final void setFuture(Future<?> future) {
        Future f;
        while ((f = (Future)this.get()) != FINISHED) {
            if (f == DISPOSED) {
                this.cancelFuture(future);
                break;
            }
            if (!this.compareAndSet(f, future)) continue;
            break;
        }
    }

    private void cancelFuture(Future<?> future) {
        if (this.runner == Thread.currentThread()) {
            future.cancel(false);
        } else {
            future.cancel(this.interruptOnCancel);
        }
    }

    @Override
    public Runnable getWrappedRunnable() {
        return this.runnable;
    }

    @Override
    public String toString() {
        Thread r;
        Future f = (Future)this.get();
        String status = f == FINISHED ? "Finished" : (f == DISPOSED ? "Disposed" : ((r = this.runner) != null ? "Running on " + this.runner : "Waiting"));
        return this.getClass().getSimpleName() + "[" + status + "]";
    }
}

