/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.schedulers;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.NonNull;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public final class ImmediateThinScheduler
extends Scheduler {
    public static final Scheduler INSTANCE = new ImmediateThinScheduler();
    static final Scheduler.Worker WORKER = new ImmediateThinWorker();
    static final Disposable DISPOSED = Disposable.empty();

    private ImmediateThinScheduler() {
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run) {
        run.run();
        return DISPOSED;
    }

    @Override
    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException("This scheduler doesn't support delayed execution");
    }

    @Override
    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
        throw new UnsupportedOperationException("This scheduler doesn't support periodic execution");
    }

    @Override
    @NonNull
    public Scheduler.Worker createWorker() {
        return WORKER;
    }

    static {
        DISPOSED.dispose();
    }

    static final class ImmediateThinWorker
    extends Scheduler.Worker {
        ImmediateThinWorker() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run) {
            run.run();
            return DISPOSED;
        }

        @Override
        @NonNull
        public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
            throw new UnsupportedOperationException("This scheduler doesn't support delayed execution");
        }

        @Override
        @NonNull
        public Disposable schedulePeriodically(@NonNull Runnable run, long initialDelay, long period, TimeUnit unit) {
            throw new UnsupportedOperationException("This scheduler doesn't support periodic execution");
        }
    }
}

