/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscribers;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.CompositeException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.Exceptions;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Action;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Consumer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.functions.Predicate;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class ForEachWhileSubscriber<T>
extends AtomicReference<Subscription>
implements FlowableSubscriber<T>,
Disposable {
    private static final long serialVersionUID = -4403180040475402120L;
    final Predicate<? super T> onNext;
    final Consumer<? super Throwable> onError;
    final Action onComplete;
    boolean done;

    public ForEachWhileSubscriber(Predicate<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        this.onNext = onNext;
        this.onError = onError;
        this.onComplete = onComplete;
    }

    @Override
    public void onSubscribe(Subscription s) {
        SubscriptionHelper.setOnce(this, s, Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t) {
        boolean b;
        if (this.done) {
            return;
        }
        try {
            b = this.onNext.test(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            this.dispose();
            this.onError(ex);
            return;
        }
        if (!b) {
            this.dispose();
            this.onComplete();
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        try {
            this.onError.accept(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(new CompositeException(t, ex));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        try {
            this.onComplete.run();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
        }
    }

    @Override
    public void dispose() {
        SubscriptionHelper.cancel(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }
}

