/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscribers;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.exceptions.MissingBackpressureException;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscribers.QueueDrainSubscriberPad4;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.BackpressureHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.QueueDrain;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.QueueDrainHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.operators.SimplePlainQueue;

public abstract class QueueDrainSubscriber<T, U, V>
extends QueueDrainSubscriberPad4
implements FlowableSubscriber<T>,
QueueDrain<U, V> {
    protected final Subscriber<? super V> downstream;
    protected final SimplePlainQueue<U> queue;
    protected volatile boolean cancelled;
    protected volatile boolean done;
    protected Throwable error;

    public QueueDrainSubscriber(Subscriber<? super V> actual, SimplePlainQueue<U> queue) {
        this.downstream = actual;
        this.queue = queue;
    }

    @Override
    public final boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public final boolean enter() {
        return this.wip.getAndIncrement() == 0;
    }

    public final boolean fastEnter() {
        return this.wip.get() == 0 && this.wip.compareAndSet(0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void fastPathEmitMax(U value, boolean delayError, Disposable dispose) {
        Subscriber<V> s = this.downstream;
        SimplePlainQueue<U> q = this.queue;
        if (this.fastEnter()) {
            long r = this.requested.get();
            if (r == 0L) {
                dispose.dispose();
                s.onError(MissingBackpressureException.createDefault());
                return;
            }
            if (this.accept((Subscriber<? super V>)s, value) && r != Long.MAX_VALUE) {
                this.produced(1L);
            }
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q, s, delayError, dispose, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void fastPathOrderedEmitMax(U value, boolean delayError, Disposable dispose) {
        Subscriber<V> s = this.downstream;
        SimplePlainQueue<U> q = this.queue;
        if (this.fastEnter()) {
            long r = this.requested.get();
            if (r == 0L) {
                this.cancelled = true;
                dispose.dispose();
                s.onError(MissingBackpressureException.createDefault());
                return;
            }
            if (q.isEmpty()) {
                if (this.accept((Subscriber<? super V>)s, value) && r != Long.MAX_VALUE) {
                    this.produced(1L);
                }
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                q.offer(value);
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainMaxLoop(q, s, delayError, dispose, this);
    }

    @Override
    public boolean accept(Subscriber<? super V> a, U v) {
        return false;
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final int leave(int m) {
        return this.wip.addAndGet(m);
    }

    @Override
    public final long requested() {
        return this.requested.get();
    }

    @Override
    public final long produced(long n) {
        return this.requested.addAndGet(-n);
    }

    public final void requested(long n) {
        if (SubscriptionHelper.validate(n)) {
            BackpressureHelper.add(this.requested, n);
        }
    }
}

