/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscribers;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.AtomicThrowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.HalfSerializer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class StrictSubscriber<T>
extends AtomicInteger
implements FlowableSubscriber<T>,
Subscription {
    private static final long serialVersionUID = -4945028590049415624L;
    final Subscriber<? super T> downstream;
    final AtomicThrowable error;
    final AtomicLong requested;
    final AtomicReference<Subscription> upstream;
    final AtomicBoolean once;
    volatile boolean done;

    public StrictSubscriber(Subscriber<? super T> downstream) {
        this.downstream = downstream;
        this.error = new AtomicThrowable();
        this.requested = new AtomicLong();
        this.upstream = new AtomicReference();
        this.once = new AtomicBoolean();
    }

    @Override
    public void request(long n) {
        if (n <= 0L) {
            this.cancel();
            this.onError(new IllegalArgumentException("\u00a73.9 violated: positive request amount required but it was " + n));
        } else {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }
    }

    @Override
    public void cancel() {
        if (!this.done) {
            SubscriptionHelper.cancel(this.upstream);
        }
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.once.compareAndSet(false, true)) {
            this.downstream.onSubscribe(this);
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s);
        } else {
            s.cancel();
            this.cancel();
            this.onError(new IllegalStateException("\u00a72.12 violated: onSubscribe must be called at most once"));
        }
    }

    @Override
    public void onNext(T t) {
        HalfSerializer.onNext(this.downstream, t, (AtomicInteger)this, this.error);
    }

    @Override
    public void onError(Throwable t) {
        this.done = true;
        HalfSerializer.onError(this.downstream, t, (AtomicInteger)this, this.error);
    }

    @Override
    public void onComplete() {
        this.done = true;
        HalfSerializer.onComplete(this.downstream, (AtomicInteger)this, this.error);
    }
}

