/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.processors;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.CheckReturnValue;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.NonNull;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.Nullable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.functions.ObjectHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.BackpressureHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.ExceptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.processors.FlowableProcessor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class ReplayProcessor<@NonNull T>
extends FlowableProcessor<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    final ReplayBuffer<T> buffer;
    boolean done;
    final AtomicReference<ReplaySubscription<T>[]> subscribers;
    static final ReplaySubscription[] EMPTY = new ReplaySubscription[0];
    static final ReplaySubscription[] TERMINATED = new ReplaySubscription[0];

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> create() {
        return new ReplayProcessor(new UnboundedReplayBuffer(16));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> create(int capacityHint) {
        ObjectHelper.verifyPositive(capacityHint, "capacityHint");
        return new ReplayProcessor(new UnboundedReplayBuffer(capacityHint));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithSize(int maxSize) {
        ObjectHelper.verifyPositive(maxSize, "maxSize");
        return new ReplayProcessor(new SizeBoundReplayBuffer(maxSize));
    }

    @CheckReturnValue
    static <T> ReplayProcessor<T> createUnbounded() {
        return new ReplayProcessor(new SizeBoundReplayBuffer(Integer.MAX_VALUE));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithTime(long maxAge, @NonNull TimeUnit unit, @NonNull Scheduler scheduler) {
        ObjectHelper.verifyPositive(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(Integer.MAX_VALUE, maxAge, unit, scheduler));
    }

    @CheckReturnValue
    @NonNull
    public static <T> ReplayProcessor<T> createWithTimeAndSize(long maxAge, @NonNull TimeUnit unit, @NonNull Scheduler scheduler, int maxSize) {
        ObjectHelper.verifyPositive(maxSize, "maxSize");
        ObjectHelper.verifyPositive(maxAge, "maxAge");
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(scheduler, "scheduler is null");
        return new ReplayProcessor(new SizeAndTimeBoundReplayBuffer(maxSize, maxAge, unit, scheduler));
    }

    ReplayProcessor(ReplayBuffer<T> buffer) {
        this.buffer = buffer;
        this.subscribers = new AtomicReference<ReplaySubscription[]>(EMPTY);
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        ReplaySubscription<? super T> rs = new ReplaySubscription<T>(s, this);
        s.onSubscribe(rs);
        if (this.add(rs) && rs.cancelled) {
            this.remove(rs);
            return;
        }
        this.buffer.replay(rs);
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.done) {
            s.cancel();
            return;
        }
        s.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T t) {
        ExceptionHelper.nullCheck(t, "onNext called with a null value.");
        if (this.done) {
            return;
        }
        ReplayBuffer<T> b = this.buffer;
        b.next(t);
        for (ReplaySubscription<T> rs : this.subscribers.get()) {
            b.replay(rs);
        }
    }

    @Override
    public void onError(Throwable t) {
        ExceptionHelper.nullCheck(t, "onError called with a null Throwable.");
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        ReplayBuffer<T> b = this.buffer;
        b.error(t);
        for (ReplaySubscription rs : this.subscribers.getAndSet(TERMINATED)) {
            b.replay(rs);
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        ReplayBuffer<T> b = this.buffer;
        b.complete();
        for (ReplaySubscription rs : this.subscribers.getAndSet(TERMINATED)) {
            b.replay(rs);
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasSubscribers() {
        return this.subscribers.get().length != 0;
    }

    @CheckReturnValue
    int subscriberCount() {
        return this.subscribers.get().length;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        ReplayBuffer<T> b = this.buffer;
        if (b.isDone()) {
            return b.getError();
        }
        return null;
    }

    public void cleanupBuffer() {
        this.buffer.trimHead();
    }

    @CheckReturnValue
    public T getValue() {
        return this.buffer.getValue();
    }

    @CheckReturnValue
    public Object[] getValues() {
        Object[] a = EMPTY_ARRAY;
        Object[] b = this.getValues(a);
        if (b == EMPTY_ARRAY) {
            return new Object[0];
        }
        return b;
    }

    @CheckReturnValue
    public T[] getValues(T[] array) {
        return this.buffer.getValues(array);
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        ReplayBuffer<T> b = this.buffer;
        return b.isDone() && b.getError() == null;
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        ReplayBuffer<T> b = this.buffer;
        return b.isDone() && b.getError() != null;
    }

    @CheckReturnValue
    public boolean hasValue() {
        return this.buffer.size() != 0;
    }

    @CheckReturnValue
    int size() {
        return this.buffer.size();
    }

    boolean add(ReplaySubscription<T> rs) {
        ReplaySubscription[] b;
        ReplaySubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new ReplaySubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.subscribers.compareAndSet(a, b));
        return true;
    }

    void remove(ReplaySubscription<T> rs) {
        ReplaySubscription[] b;
        ReplaySubscription<T>[] a;
        do {
            if ((a = this.subscribers.get()) == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new ReplaySubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.subscribers.compareAndSet(a, b));
    }

    static final class SizeAndTimeBoundReplayBuffer<T>
    implements ReplayBuffer<T> {
        final int maxSize;
        final long maxAge;
        final TimeUnit unit;
        final Scheduler scheduler;
        int size;
        volatile TimedNode<T> head;
        TimedNode<T> tail;
        Throwable error;
        volatile boolean done;

        SizeAndTimeBoundReplayBuffer(int maxSize, long maxAge, TimeUnit unit, Scheduler scheduler) {
            this.maxSize = maxSize;
            this.maxAge = maxAge;
            this.unit = unit;
            this.scheduler = scheduler;
            TimedNode<Object> h = new TimedNode<Object>(null, 0L);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                TimedNode<T> h = this.head;
                this.head = (TimedNode)h.get();
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                if (this.size <= 1) {
                    this.head = h;
                    break;
                }
                TimedNode next = (TimedNode)h.get();
                if (next.time > limit) {
                    this.head = h;
                    break;
                }
                h = next;
                --this.size;
            }
        }

        void trimFinal() {
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode h = this.head;
            while (true) {
                TimedNode next;
                if ((next = (TimedNode)h.get()) == null) {
                    if (h.value != null) {
                        this.head = new TimedNode<Object>(null, 0L);
                        break;
                    }
                    this.head = h;
                    break;
                }
                if (next.time > limit) {
                    if (h.value != null) {
                        TimedNode<Object> n = new TimedNode<Object>(null, 0L);
                        n.lazySet(h.get());
                        this.head = n;
                        break;
                    }
                    this.head = h;
                    break;
                }
                h = next;
            }
        }

        @Override
        public void trimHead() {
            if (this.head.value != null) {
                TimedNode<Object> n = new TimedNode<Object>(null, 0L);
                n.lazySet(this.head.get());
                this.head = n;
            }
        }

        @Override
        public void next(T value) {
            TimedNode<T> n = new TimedNode<T>(value, this.scheduler.now(this.unit));
            TimedNode<T> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void error(Throwable ex) {
            this.trimFinal();
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimFinal();
            this.done = true;
        }

        @Override
        @Nullable
        public T getValue() {
            TimedNode next;
            TimedNode h = this.head;
            while ((next = (TimedNode)h.get()) != null) {
                h = next;
            }
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            if (h.time < limit) {
                return null;
            }
            return h.value;
        }

        @Override
        public T[] getValues(T[] array) {
            TimedNode h = this.getHead();
            int s = this.size(h);
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
            } else {
                if (array.length < s) {
                    array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
                }
                for (int i = 0; i != s; ++i) {
                    TimedNode next = (TimedNode)h.get();
                    array[i] = next.value;
                    h = next;
                }
                if (array.length > s) {
                    array[s] = null;
                }
            }
            return array;
        }

        TimedNode<T> getHead() {
            long ts;
            TimedNode index = this.head;
            long limit = this.scheduler.now(this.unit) - this.maxAge;
            TimedNode next = (TimedNode)index.get();
            while (next != null && (ts = next.time) <= limit) {
                index = next;
                next = (TimedNode)index.get();
            }
            return index;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = rs.downstream;
            TimedNode index = (TimedNode)rs.index;
            if (index == null) {
                index = this.getHead();
            }
            long e = rs.emitted;
            do {
                boolean d;
                long r = rs.requested.get();
                while (e != r) {
                    boolean empty;
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    TimedNode next = (TimedNode)index.get();
                    boolean bl = empty = next == null;
                    if (d && empty) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(next.value);
                    ++e;
                    index = next;
                }
                if (e == r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    if (d && index.get() == null) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.size(this.getHead());
        }

        int size(TimedNode<T> h) {
            TimedNode next;
            int s;
            for (s = 0; s != Integer.MAX_VALUE && (next = (TimedNode)h.get()) != null; ++s) {
                h = next;
            }
            return s;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }

    static final class SizeBoundReplayBuffer<@NonNull T>
    implements ReplayBuffer<T> {
        final int maxSize;
        int size;
        volatile Node<T> head;
        Node<T> tail;
        Throwable error;
        volatile boolean done;

        SizeBoundReplayBuffer(int maxSize) {
            this.maxSize = maxSize;
            Node<Object> h = new Node<Object>(null);
            this.tail = h;
            this.head = h;
        }

        void trim() {
            if (this.size > this.maxSize) {
                --this.size;
                Node<T> h = this.head;
                this.head = (Node)h.get();
            }
        }

        @Override
        public void next(T value) {
            Node<T> n = new Node<T>(value);
            Node<T> t = this.tail;
            this.tail = n;
            ++this.size;
            t.set(n);
            this.trim();
        }

        @Override
        public void error(Throwable ex) {
            this.error = ex;
            this.trimHead();
            this.done = true;
        }

        @Override
        public void complete() {
            this.trimHead();
            this.done = true;
        }

        @Override
        public void trimHead() {
            if (this.head.value != null) {
                Node<Object> n = new Node<Object>(null);
                n.lazySet(this.head.get());
                this.head = n;
            }
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public T getValue() {
            Node h = this.head;
            Node n;
            while ((n = (Node)h.get()) != null) {
                h = n;
            }
            return h.value;
        }

        @Override
        public T[] getValues(T[] array) {
            Node next;
            Node h;
            int s = 0;
            Node h0 = h = this.head;
            while ((next = (Node)h0.get()) != null) {
                ++s;
                h0 = next;
            }
            if (array.length < s) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
            }
            for (int j = 0; j < s; ++j) {
                h = (Node)h.get();
                array[j] = h.value;
            }
            if (array.length > s) {
                array[s] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = rs.downstream;
            Node index = (Node)rs.index;
            if (index == null) {
                index = this.head;
            }
            long e = rs.emitted;
            do {
                boolean d;
                long r = rs.requested.get();
                while (e != r) {
                    boolean empty;
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    Node next = (Node)index.get();
                    boolean bl = empty = next == null;
                    if (d && empty) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(next.value);
                    ++e;
                    index = next;
                }
                if (e == r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    if (d && index.get() == null) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            Node next;
            int s;
            Node h = this.head;
            for (s = 0; s != Integer.MAX_VALUE && (next = (Node)h.get()) != null; ++s) {
                h = next;
            }
            return s;
        }
    }

    static final class TimedNode<T>
    extends AtomicReference<TimedNode<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;
        final long time;

        TimedNode(T value, long time) {
            this.value = value;
            this.time = time;
        }
    }

    static final class Node<T>
    extends AtomicReference<Node<T>> {
        private static final long serialVersionUID = 6404226426336033100L;
        final T value;

        Node(T value) {
            this.value = value;
        }
    }

    static final class UnboundedReplayBuffer<T>
    implements ReplayBuffer<T> {
        final List<T> buffer;
        Throwable error;
        volatile boolean done;
        volatile int size;

        UnboundedReplayBuffer(int capacityHint) {
            this.buffer = new ArrayList<T>(capacityHint);
        }

        @Override
        public void next(T value) {
            this.buffer.add(value);
            ++this.size;
        }

        @Override
        public void error(Throwable ex) {
            this.error = ex;
            this.done = true;
        }

        @Override
        public void complete() {
            this.done = true;
        }

        @Override
        public void trimHead() {
        }

        @Override
        @Nullable
        public T getValue() {
            int s = this.size;
            if (s == 0) {
                return null;
            }
            return this.buffer.get(s - 1);
        }

        @Override
        public T[] getValues(T[] array) {
            int s = this.size;
            if (s == 0) {
                if (array.length != 0) {
                    array[0] = null;
                }
                return array;
            }
            List<T> b = this.buffer;
            if (array.length < s) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), s);
            }
            for (int i = 0; i < s; ++i) {
                array[i] = b.get(i);
            }
            if (array.length > s) {
                array[s] = null;
            }
            return array;
        }

        @Override
        public void replay(ReplaySubscription<T> rs) {
            int index;
            if (rs.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            List<T> b = this.buffer;
            Subscriber<T> a = rs.downstream;
            Integer indexObject = (Integer)rs.index;
            if (indexObject != null) {
                index = indexObject;
            } else {
                index = 0;
                rs.index = 0;
            }
            long e = rs.emitted;
            do {
                int s;
                boolean d;
                long r = rs.requested.get();
                while (e != r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    s = this.size;
                    if (d && index == s) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                    if (index == s) break;
                    a.onNext(b.get(index));
                    ++index;
                    ++e;
                }
                if (e == r) {
                    if (rs.cancelled) {
                        rs.index = null;
                        return;
                    }
                    d = this.done;
                    s = this.size;
                    if (d && index == s) {
                        rs.index = null;
                        rs.cancelled = true;
                        Throwable ex = this.error;
                        if (ex == null) {
                            a.onComplete();
                        } else {
                            a.onError(ex);
                        }
                        return;
                    }
                }
                rs.index = index;
                rs.emitted = e;
            } while ((missed = rs.addAndGet(-missed)) != 0);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }
    }

    static final class ReplaySubscription<@NonNull T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 466549804534799122L;
        final Subscriber<? super T> downstream;
        final ReplayProcessor<T> state;
        Object index;
        final AtomicLong requested;
        volatile boolean cancelled;
        long emitted;

        ReplaySubscription(Subscriber<? super T> actual, ReplayProcessor<T> state) {
            this.downstream = actual;
            this.state = state;
            this.requested = new AtomicLong();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.state.buffer.replay(this);
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }
    }

    static interface ReplayBuffer<@NonNull T> {
        public void next(T var1);

        public void error(Throwable var1);

        public void complete();

        public void replay(ReplaySubscription<T> var1);

        public int size();

        @Nullable
        public T getValue();

        public T[] getValues(T[] var1);

        public boolean isDone();

        public Throwable getError();

        public void trimHead();
    }
}

