/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.subjects;

import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.CheckReturnValue;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.NonNull;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.Nullable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observer;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.disposables.Disposable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.AppendOnlyLinkedArrayList;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.ExceptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.util.NotificationLite;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.subjects.Subject;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class BehaviorSubject<T>
extends Subject<T> {
    final AtomicReference<Object> value;
    final AtomicReference<BehaviorDisposable<T>[]> observers;
    static final BehaviorDisposable[] EMPTY = new BehaviorDisposable[0];
    static final BehaviorDisposable[] TERMINATED = new BehaviorDisposable[0];
    final ReadWriteLock lock = new ReentrantReadWriteLock();
    final Lock readLock = this.lock.readLock();
    final Lock writeLock = this.lock.writeLock();
    final AtomicReference<Throwable> terminalEvent;
    long index;

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorSubject<T> create() {
        return new BehaviorSubject<Object>(null);
    }

    @CheckReturnValue
    @NonNull
    public static <T> BehaviorSubject<T> createDefault(T defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        return new BehaviorSubject<T>(defaultValue);
    }

    BehaviorSubject(T defaultValue) {
        this.observers = new AtomicReference<BehaviorDisposable[]>(EMPTY);
        this.value = new AtomicReference<T>(defaultValue);
        this.terminalEvent = new AtomicReference();
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        BehaviorDisposable<T> bs = new BehaviorDisposable<T>(observer, this);
        observer.onSubscribe(bs);
        if (this.add(bs)) {
            if (bs.cancelled) {
                this.remove(bs);
            } else {
                bs.emitFirst();
            }
        } else {
            Throwable ex = this.terminalEvent.get();
            if (ex == ExceptionHelper.TERMINATED) {
                observer.onComplete();
            } else {
                observer.onError(ex);
            }
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (this.terminalEvent.get() != null) {
            d.dispose();
        }
    }

    @Override
    public void onNext(T t) {
        ExceptionHelper.nullCheck(t, "onNext called with a null value.");
        if (this.terminalEvent.get() != null) {
            return;
        }
        Object o = NotificationLite.next(t);
        this.setCurrent(o);
        for (BehaviorDisposable<T> bs : this.observers.get()) {
            bs.emitNext(o, this.index);
        }
    }

    @Override
    public void onError(Throwable t) {
        ExceptionHelper.nullCheck(t, "onError called with a null Throwable.");
        if (!this.terminalEvent.compareAndSet(null, t)) {
            RxJavaPlugins.onError(t);
            return;
        }
        Object o = NotificationLite.error(t);
        for (BehaviorDisposable<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    @Override
    public void onComplete() {
        if (!this.terminalEvent.compareAndSet(null, ExceptionHelper.TERMINATED)) {
            return;
        }
        Object o = NotificationLite.complete();
        for (BehaviorDisposable<T> bs : this.terminate(o)) {
            bs.emitNext(o, this.index);
        }
    }

    @Override
    @CheckReturnValue
    public boolean hasObservers() {
        return this.observers.get().length != 0;
    }

    @CheckReturnValue
    int subscriberCount() {
        return this.observers.get().length;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public Throwable getThrowable() {
        Object o = this.value.get();
        if (NotificationLite.isError(o)) {
            return NotificationLite.getError(o);
        }
        return null;
    }

    @CheckReturnValue
    @Nullable
    public T getValue() {
        Object o = this.value.get();
        if (NotificationLite.isComplete(o) || NotificationLite.isError(o)) {
            return null;
        }
        return NotificationLite.getValue(o);
    }

    @Override
    @CheckReturnValue
    public boolean hasComplete() {
        Object o = this.value.get();
        return NotificationLite.isComplete(o);
    }

    @Override
    @CheckReturnValue
    public boolean hasThrowable() {
        Object o = this.value.get();
        return NotificationLite.isError(o);
    }

    @CheckReturnValue
    public boolean hasValue() {
        Object o = this.value.get();
        return o != null && !NotificationLite.isComplete(o) && !NotificationLite.isError(o);
    }

    boolean add(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            if ((a = this.observers.get()) == TERMINATED) {
                return false;
            }
            int len = a.length;
            b = new BehaviorDisposable[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = rs;
        } while (!this.observers.compareAndSet(a, b));
        return true;
    }

    void remove(BehaviorDisposable<T> rs) {
        BehaviorDisposable[] b;
        BehaviorDisposable<T>[] a;
        do {
            int len;
            if ((len = (a = this.observers.get()).length) == 0) {
                return;
            }
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != rs) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                b = EMPTY;
                continue;
            }
            b = new BehaviorDisposable[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
        } while (!this.observers.compareAndSet(a, b));
    }

    BehaviorDisposable<T>[] terminate(Object terminalValue) {
        this.setCurrent(terminalValue);
        return this.observers.getAndSet(TERMINATED);
    }

    void setCurrent(Object o) {
        this.writeLock.lock();
        ++this.index;
        this.value.lazySet(o);
        this.writeLock.unlock();
    }

    static final class BehaviorDisposable<T>
    implements Disposable,
    AppendOnlyLinkedArrayList.NonThrowingPredicate<Object> {
        final Observer<? super T> downstream;
        final BehaviorSubject<T> state;
        boolean next;
        boolean emitting;
        AppendOnlyLinkedArrayList<Object> queue;
        boolean fastPath;
        volatile boolean cancelled;
        long index;

        BehaviorDisposable(Observer<? super T> actual, BehaviorSubject<T> state) {
            this.downstream = actual;
            this.state = state;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.state.remove(this);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitFirst() {
            Object o;
            if (this.cancelled) {
                return;
            }
            BehaviorDisposable behaviorDisposable = this;
            synchronized (behaviorDisposable) {
                if (this.cancelled) {
                    return;
                }
                if (this.next) {
                    return;
                }
                BehaviorSubject<T> s = this.state;
                Lock lock = s.readLock;
                lock.lock();
                this.index = s.index;
                o = s.value.get();
                lock.unlock();
                this.emitting = o != null;
                this.next = true;
            }
            if (o != null) {
                if (this.test(o)) {
                    return;
                }
                this.emitLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitNext(Object value, long stateIndex) {
            if (this.cancelled) {
                return;
            }
            if (!this.fastPath) {
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    if (this.cancelled) {
                        return;
                    }
                    if (this.index == stateIndex) {
                        return;
                    }
                    if (this.emitting) {
                        AppendOnlyLinkedArrayList<Object> q = this.queue;
                        if (q == null) {
                            this.queue = q = new AppendOnlyLinkedArrayList(4);
                        }
                        q.add(value);
                        return;
                    }
                    this.next = true;
                }
                this.fastPath = true;
            }
            this.test(value);
        }

        @Override
        public boolean test(Object o) {
            return this.cancelled || NotificationLite.accept(o, this.downstream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emitLoop() {
            while (!this.cancelled) {
                AppendOnlyLinkedArrayList<Object> q;
                BehaviorDisposable behaviorDisposable = this;
                synchronized (behaviorDisposable) {
                    q = this.queue;
                    if (q == null) {
                        this.emitting = false;
                        return;
                    }
                    this.queue = null;
                }
                q.forEachWhile(this);
            }
            return;
        }
    }
}

