/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.subscribers;

import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscriber;
import it.renvins.serverpulse.velocity.libs.reactivestreams.Subscription;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.annotations.NonNull;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.FlowableSubscriber;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.observers.BaseTestConsumer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class TestSubscriber<T>
extends BaseTestConsumer<T, TestSubscriber<T>>
implements FlowableSubscriber<T>,
Subscription {
    private final Subscriber<? super T> downstream;
    private volatile boolean cancelled;
    private final AtomicReference<Subscription> upstream;
    private final AtomicLong missedRequested;

    @NonNull
    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    @NonNull
    public static <T> TestSubscriber<T> create(long initialRequested) {
        return new TestSubscriber<T>(initialRequested);
    }

    public static <T> TestSubscriber<T> create(@NonNull Subscriber<? super T> delegate) {
        return new TestSubscriber<T>(delegate);
    }

    public TestSubscriber() {
        this(EmptySubscriber.INSTANCE, Long.MAX_VALUE);
    }

    public TestSubscriber(long initialRequest) {
        this(EmptySubscriber.INSTANCE, initialRequest);
    }

    public TestSubscriber(@NonNull Subscriber<? super T> downstream) {
        this(downstream, Long.MAX_VALUE);
    }

    public TestSubscriber(@NonNull Subscriber<? super T> actual, long initialRequest) {
        if (initialRequest < 0L) {
            throw new IllegalArgumentException("Negative initial request not allowed");
        }
        this.downstream = actual;
        this.upstream = new AtomicReference();
        this.missedRequested = new AtomicLong(initialRequest);
    }

    @Override
    public void onSubscribe(@NonNull Subscription s) {
        this.lastThread = Thread.currentThread();
        if (s == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.upstream.compareAndSet(null, s)) {
            s.cancel();
            if (this.upstream.get() != SubscriptionHelper.CANCELLED) {
                this.errors.add(new IllegalStateException("onSubscribe received multiple subscriptions: " + s));
            }
            return;
        }
        this.downstream.onSubscribe(s);
        long mr = this.missedRequested.getAndSet(0L);
        if (mr != 0L) {
            s.request(mr);
        }
        this.onStart();
    }

    protected void onStart() {
    }

    @Override
    public void onNext(@NonNull T t) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        this.values.add(t);
        if (t == null) {
            this.errors.add(new NullPointerException("onNext received a null value"));
        }
        this.downstream.onNext(t);
    }

    @Override
    public void onError(@NonNull Throwable t) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            if (t == null) {
                this.errors.add(new NullPointerException("onError received a null Throwable"));
            } else {
                this.errors.add(t);
            }
            this.downstream.onError(t);
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.downstream.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public final void request(long n) {
        SubscriptionHelper.deferredRequest(this.upstream, this.missedRequested, n);
    }

    @Override
    public final void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.upstream);
        }
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    protected final void dispose() {
        this.cancel();
    }

    @Override
    protected final boolean isDisposed() {
        return this.cancelled;
    }

    public final boolean hasSubscription() {
        return this.upstream.get() != null;
    }

    @Override
    protected final TestSubscriber<T> assertSubscribed() {
        if (this.upstream.get() == null) {
            throw this.fail("Not subscribed!");
        }
        return this;
    }

    public final TestSubscriber<T> requestMore(long n) {
        this.request(n);
        return this;
    }

    static enum EmptySubscriber implements FlowableSubscriber<Object>
    {
        INSTANCE;


        @Override
        public void onSubscribe(Subscription s) {
        }

        @Override
        public void onNext(Object t) {
        }

        @Override
        public void onError(Throwable t) {
        }

        @Override
        public void onComplete() {
        }
    }
}

