/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.retrofit2;

import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.kotlin.Unit;
import it.renvins.serverpulse.velocity.libs.okhttp3.RequestBody;
import it.renvins.serverpulse.velocity.libs.okhttp3.ResponseBody;
import it.renvins.serverpulse.velocity.libs.retrofit2.Converter;
import it.renvins.serverpulse.velocity.libs.retrofit2.Retrofit;
import it.renvins.serverpulse.velocity.libs.retrofit2.Utils;
import it.renvins.serverpulse.velocity.libs.retrofit2.http.Streaming;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

final class BuiltInConverters
extends Converter.Factory {
    BuiltInConverters() {
    }

    @Override
    @Nullable
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (type == ResponseBody.class) {
            return Utils.isAnnotationPresent(annotations, Streaming.class) ? StreamingResponseBodyConverter.INSTANCE : BufferingResponseBodyConverter.INSTANCE;
        }
        if (type == Void.class) {
            return VoidResponseBodyConverter.INSTANCE;
        }
        if (Utils.isUnit(type)) {
            return UnitResponseBodyConverter.INSTANCE;
        }
        return null;
    }

    @Override
    @Nullable
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        if (RequestBody.class.isAssignableFrom(Utils.getRawType(type))) {
            return RequestBodyConverter.INSTANCE;
        }
        return null;
    }

    static final class ToStringConverter
    implements Converter<Object, String> {
        static final ToStringConverter INSTANCE = new ToStringConverter();

        ToStringConverter() {
        }

        @Override
        public String convert(Object value) {
            return value.toString();
        }
    }

    static final class BufferingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final BufferingResponseBodyConverter INSTANCE = new BufferingResponseBodyConverter();

        BufferingResponseBodyConverter() {
        }

        @Override
        public ResponseBody convert(ResponseBody value) throws IOException {
            try {
                ResponseBody responseBody = Utils.buffer(value);
                return responseBody;
            }
            finally {
                value.close();
            }
        }
    }

    static final class StreamingResponseBodyConverter
    implements Converter<ResponseBody, ResponseBody> {
        static final StreamingResponseBodyConverter INSTANCE = new StreamingResponseBodyConverter();

        StreamingResponseBodyConverter() {
        }

        @Override
        public ResponseBody convert(ResponseBody value) {
            return value;
        }
    }

    static final class RequestBodyConverter
    implements Converter<RequestBody, RequestBody> {
        static final RequestBodyConverter INSTANCE = new RequestBodyConverter();

        RequestBodyConverter() {
        }

        @Override
        public RequestBody convert(RequestBody value) {
            return value;
        }
    }

    static final class UnitResponseBodyConverter
    implements Converter<ResponseBody, Unit> {
        static final UnitResponseBodyConverter INSTANCE = new UnitResponseBodyConverter();

        UnitResponseBodyConverter() {
        }

        @Override
        public Unit convert(ResponseBody value) {
            value.close();
            return Unit.INSTANCE;
        }
    }

    static final class VoidResponseBodyConverter
    implements Converter<ResponseBody, Void> {
        static final VoidResponseBodyConverter INSTANCE = new VoidResponseBodyConverter();

        VoidResponseBodyConverter() {
        }

        @Override
        public Void convert(ResponseBody value) {
            value.close();
            return null;
        }
    }
}

