/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.retrofit2;

import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.retrofit2.HttpServiceMethod;
import it.renvins.serverpulse.velocity.libs.retrofit2.RequestFactory;
import it.renvins.serverpulse.velocity.libs.retrofit2.Retrofit;
import it.renvins.serverpulse.velocity.libs.retrofit2.Utils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

abstract class ServiceMethod<T> {
    ServiceMethod() {
    }

    static <T> ServiceMethod<T> parseAnnotations(Retrofit retrofit, Class<?> service, Method method) {
        RequestFactory requestFactory = RequestFactory.parseAnnotations(retrofit, service, method);
        Type returnType = method.getGenericReturnType();
        if (Utils.hasUnresolvableType(returnType)) {
            throw Utils.methodError(method, "Method return type must not include a type variable or wildcard: %s", returnType);
        }
        if (returnType == Void.TYPE) {
            throw Utils.methodError(method, "Service methods cannot return void.", new Object[0]);
        }
        return HttpServiceMethod.parseAnnotations(retrofit, method, requestFactory);
    }

    @Nullable
    abstract T invoke(Object var1, Object[] var2);
}

