/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3;

import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.BackpressureStrategy;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.plugins.RxJavaPlugins;
import it.renvins.serverpulse.velocity.libs.retrofit2.Call;
import it.renvins.serverpulse.velocity.libs.retrofit2.CallAdapter;
import it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3.BodyObservable;
import it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3.CallEnqueueObservable;
import it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3.CallExecuteObservable;
import it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3.ResultObservable;
import java.lang.reflect.Type;

final class RxJava3CallAdapter<R>
implements CallAdapter<R, Object> {
    private final Type responseType;
    @Nullable
    private final Scheduler scheduler;
    private final boolean isAsync;
    private final boolean isResult;
    private final boolean isBody;
    private final boolean isFlowable;
    private final boolean isSingle;
    private final boolean isMaybe;
    private final boolean isCompletable;

    RxJava3CallAdapter(Type responseType, @Nullable Scheduler scheduler, boolean isAsync, boolean isResult, boolean isBody, boolean isFlowable, boolean isSingle, boolean isMaybe, boolean isCompletable) {
        this.responseType = responseType;
        this.scheduler = scheduler;
        this.isAsync = isAsync;
        this.isResult = isResult;
        this.isBody = isBody;
        this.isFlowable = isFlowable;
        this.isSingle = isSingle;
        this.isMaybe = isMaybe;
        this.isCompletable = isCompletable;
    }

    @Override
    public Type responseType() {
        return this.responseType;
    }

    @Override
    public Object adapt(Call<R> call) {
        Observable responseObservable;
        Observable observable2 = responseObservable = this.isAsync ? new CallEnqueueObservable<R>(call) : new CallExecuteObservable<R>(call);
        Observable observable3 = this.isResult ? new ResultObservable(responseObservable) : (this.isBody ? new BodyObservable(responseObservable) : responseObservable);
        if (this.scheduler != null) {
            observable3 = observable3.subscribeOn(this.scheduler);
        }
        if (this.isFlowable) {
            return observable3.toFlowable(BackpressureStrategy.MISSING);
        }
        if (this.isSingle) {
            return observable3.singleOrError();
        }
        if (this.isMaybe) {
            return observable3.singleElement();
        }
        if (this.isCompletable) {
            return observable3.ignoreElements();
        }
        return RxJavaPlugins.onAssembly(observable3);
    }
}

