/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3;

import it.renvins.serverpulse.velocity.libs.annotation.Nullable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Completable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Flowable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Maybe;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Observable;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Scheduler;
import it.renvins.serverpulse.velocity.libs.reactivex.rxjava3.core.Single;
import it.renvins.serverpulse.velocity.libs.retrofit2.CallAdapter;
import it.renvins.serverpulse.velocity.libs.retrofit2.Response;
import it.renvins.serverpulse.velocity.libs.retrofit2.Retrofit;
import it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3.Result;
import it.renvins.serverpulse.velocity.libs.retrofit2.adapter.rxjava3.RxJava3CallAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class RxJava3CallAdapterFactory
extends CallAdapter.Factory {
    @Nullable
    private final Scheduler scheduler;
    private final boolean isAsync;

    public static RxJava3CallAdapterFactory create() {
        return new RxJava3CallAdapterFactory(null, true);
    }

    public static RxJava3CallAdapterFactory createSynchronous() {
        return new RxJava3CallAdapterFactory(null, false);
    }

    public static RxJava3CallAdapterFactory createWithScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            throw new NullPointerException("scheduler == null");
        }
        return new RxJava3CallAdapterFactory(scheduler, false);
    }

    private RxJava3CallAdapterFactory(@Nullable Scheduler scheduler, boolean isAsync) {
        this.scheduler = scheduler;
        this.isAsync = isAsync;
    }

    @Override
    @Nullable
    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        Type responseType;
        boolean isMaybe;
        Class<?> rawType = RxJava3CallAdapterFactory.getRawType(returnType);
        if (rawType == Completable.class) {
            return new RxJava3CallAdapter((Type)((Object)Void.class), this.scheduler, this.isAsync, false, true, false, false, false, true);
        }
        boolean isFlowable = rawType == Flowable.class;
        boolean isSingle = rawType == Single.class;
        boolean bl = isMaybe = rawType == Maybe.class;
        if (!(rawType == Observable.class || isFlowable || isSingle || isMaybe)) {
            return null;
        }
        boolean isResult = false;
        boolean isBody = false;
        if (!(returnType instanceof ParameterizedType)) {
            String name = isFlowable ? "Flowable" : (isSingle ? "Single" : (isMaybe ? "Maybe" : "Observable"));
            throw new IllegalStateException(name + " return type must be parameterized as " + name + "<Foo> or " + name + "<? extends Foo>");
        }
        Type observableType = RxJava3CallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)returnType);
        Class<?> rawObservableType = RxJava3CallAdapterFactory.getRawType(observableType);
        if (rawObservableType == Response.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Response must be parameterized as Response<Foo> or Response<? extends Foo>");
            }
            responseType = RxJava3CallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)observableType);
        } else if (rawObservableType == Result.class) {
            if (!(observableType instanceof ParameterizedType)) {
                throw new IllegalStateException("Result must be parameterized as Result<Foo> or Result<? extends Foo>");
            }
            responseType = RxJava3CallAdapterFactory.getParameterUpperBound(0, (ParameterizedType)observableType);
            isResult = true;
        } else {
            responseType = observableType;
            isBody = true;
        }
        return new RxJava3CallAdapter(responseType, this.scheduler, this.isAsync, isResult, isBody, isFlowable, isSingle, isMaybe, false);
    }
}

