/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.comments;

import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.ConfigurationOptions;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.ConfigurationSection;
import it.renvins.serverpulse.velocity.libs.simpleyaml.utils.StringUtils;
import it.renvins.serverpulse.velocity.libs.simpleyaml.utils.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KeyTree
implements Iterable<Node> {
    protected final Node root;
    protected final ConfigurationOptions options;

    public KeyTree(ConfigurationOptions options) {
        Validate.notNull(options);
        this.options = options;
        this.root = this.createNode(null, 0, "");
    }

    public Node findParent(int indent) {
        return this.findParent(this.root, indent);
    }

    public Node getRoot() {
        return this.root;
    }

    public Node get(String path) {
        return this.root.get(path, false, false);
    }

    public Node getPriority(String path) {
        return this.root.get(path, false, true);
    }

    public Node getOrAdd(String path) {
        return this.root.get(path, true, false);
    }

    public Node add(String path) {
        return this.root.get(path, true, true);
    }

    public Set<String> keys() {
        return this.root.keys();
    }

    public List<Node> children() {
        return this.root.children();
    }

    public Set<Map.Entry<String, Node>> entries() {
        return this.root.entries();
    }

    public ConfigurationOptions options() {
        return this.options;
    }

    public String toString() {
        return this.root.toString();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.root.iterator();
    }

    protected Node findParent(Node parent, int indent) {
        Node last = parent.getLast();
        if (last != null && last.indent < indent) {
            return this.findParent(last, indent);
        }
        return parent;
    }

    protected Node createNode(Node parent, int indent, String key) {
        return new Node(parent, indent, key);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public class Node
    implements Iterable<Node> {
        protected final Node parent;
        protected String name;
        protected int indent;
        protected List<Node> children;
        protected Map<String, Node> indexByName;
        protected Map<String, Node> priorityIndex;
        protected Map<Integer, Node> indexByElementIndex;
        protected String comment;
        protected String sideComment;
        protected boolean isList;
        protected Integer listSize;
        protected Integer elementIndex;

        Node(Node parent, int indent, String name) {
            this.parent = parent;
            this.indent = indent;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getSideComment() {
            return this.sideComment;
        }

        public void setSideComment(String sideComment) {
            this.sideComment = sideComment;
        }

        public Node getParent() {
            return this.parent;
        }

        public boolean isRootNode() {
            return this.parent == null;
        }

        public boolean isFirstNode() {
            if (!this.isRootNode() && this.parent.isRootNode()) {
                Node first = this.parent.getFirst();
                if (first.getName() == null && this.parent.children.size() > 1) {
                    first = this.parent.children.get(1);
                }
                if (first == this) {
                    Iterator<String> keys2 = KeyTree.this.options.configuration().getKeys(false).iterator();
                    return !keys2.hasNext() || keys2.next().equals(first.getName());
                }
            }
            return false;
        }

        public int getIndentation() {
            return this.indent;
        }

        protected Node get(String path, boolean add, boolean priority) {
            Node node = null;
            if (!(path == null || this.indexByName != null && this.indexByName.containsKey(path))) {
                int i = StringUtils.firstSeparatorIndex(path, KeyTree.this.options.pathSeparator());
                if (i >= 0) {
                    String childPath = path.substring(0, i);
                    Node child = this.get(childPath, add, priority);
                    if (child == null) {
                        return null;
                    }
                    return child.get(path.substring(i + 1), add, priority);
                }
                Matcher listIndex = StringUtils.LIST_INDEX.matcher(path);
                if (listIndex.matches()) {
                    String child = listIndex.group(1);
                    if (child != null && !child.isEmpty()) {
                        node = this.get(child, add, priority);
                        if (node == null) {
                            return null;
                        }
                    } else {
                        node = this;
                    }
                    return node.getElement(Integer.parseInt(listIndex.group(2)), add);
                }
            }
            if (priority && this.isList) {
                Node node2 = node = this.priorityIndex != null ? this.priorityIndex.get(path) : null;
                if (add && node == null && this.indexByName != null && (node = this.indexByName.get(path)) != null) {
                    this.setPriority(path, node);
                }
            } else if (this.indexByName != null) {
                node = this.indexByName.get(path);
            }
            if (node == null && add) {
                node = this.add(path, priority);
            }
            return node;
        }

        public Node get(String path) {
            return this.get(path, false, false);
        }

        public Node getPriority(String path) {
            return this.get(path, false, true);
        }

        protected Node getElement(int i, boolean add) {
            Node child = null;
            if (this.isList) {
                if (this.indexByElementIndex != null && (child = this.indexByElementIndex.get(i)) == null && !add) {
                    child = i < 0 ? this.indexByElementIndex.get(this.listSize + i) : this.indexByElementIndex.get(i - this.listSize);
                }
            } else if (!add) {
                child = this.get(i);
            }
            if (child == null && add) {
                child = this.addIndexed(i);
            }
            return child;
        }

        public Node getElement(int i) {
            return this.getElement(i, false);
        }

        public Node get(int i) {
            Node child = null;
            if (this.hasChildren() && (i = this.asListIndex(i, this.children.size())) >= 0 && i < this.children.size()) {
                child = this.children.get(i);
            }
            return child;
        }

        public Node getFirst() {
            if (!this.hasChildren()) {
                return null;
            }
            return this.children.get(0);
        }

        public Node getLast() {
            if (!this.hasChildren()) {
                return null;
            }
            return this.children.get(this.children.size() - 1);
        }

        public Node add(String key) {
            return this.add(key, false);
        }

        public Node add(int indent, String key) {
            return this.add(indent, key, false);
        }

        protected Node add(String key, boolean priority) {
            int indent = this == KeyTree.this.root ? 0 : this.indent + KeyTree.this.options.indent();
            return this.add(indent, key, priority);
        }

        protected Node add(int indent, String key, boolean priority) {
            Node child = KeyTree.this.createNode(this, indent, key);
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            this.children.add(child);
            if (this.indexByName == null) {
                this.indexByName = new LinkedHashMap<String, Node>();
            }
            this.indexByName.putIfAbsent(key, child);
            if (priority) {
                this.setPriority(key, child);
            }
            child.checkList();
            return child;
        }

        protected void setPriority(String key, Node child) {
            if (this.priorityIndex == null) {
                this.priorityIndex = new LinkedHashMap<String, Node>();
            }
            this.priorityIndex.putIfAbsent(key, child);
        }

        protected void checkList() {
            Object value;
            if ((this.name != null || this.elementIndex != null) && (value = this.getValue()) instanceof Collection) {
                this.isList(((Collection)value).size());
            }
        }

        public Object getValue() {
            String path = this.getPath();
            return path != null ? KeyTree.this.options.configuration().get(path) : null;
        }

        public boolean hasChildren() {
            return this.children != null && !this.children.isEmpty();
        }

        public List<Node> children() {
            return this.hasChildren() ? Collections.unmodifiableList(this.children) : Collections.emptyList();
        }

        public Set<String> keys() {
            return this.indexByName != null ? Collections.unmodifiableSet(this.indexByName.keySet()) : Collections.emptySet();
        }

        public Set<Map.Entry<String, Node>> entries() {
            return this.indexByName != null ? Collections.unmodifiableSet(this.indexByName.entrySet()) : Collections.emptySet();
        }

        public int size() {
            return this.hasChildren() ? this.children.size() : 0;
        }

        public boolean isList() {
            return this.isList;
        }

        public void isList(int listSize) {
            this.isList = true;
            this.listSize = listSize;
        }

        public Integer getListSize() {
            return this.listSize;
        }

        public void setElementIndex(int elementIndex) {
            if (this.parent != null) {
                if (this.parent.indexByElementIndex == null) {
                    this.parent.indexByElementIndex = new HashMap<Integer, Node>();
                } else if (this.elementIndex != null) {
                    this.parent.indexByElementIndex.remove(this.elementIndex);
                }
                this.elementIndex = elementIndex;
                this.parent.indexByElementIndex.put(this.elementIndex, this);
            }
        }

        public Integer getElementIndex() {
            return this.elementIndex;
        }

        public String getPath() {
            if (this.parent == null || this.parent == KeyTree.this.root) {
                return this.name;
            }
            if (this.parent.isList && this.elementIndex != null) {
                return this.indexedName(this.parent.getPath(), this.elementIndex);
            }
            return this.getPathWithNameUnchecked();
        }

        public String getPathWithName() {
            if (this.parent == null || this.parent == KeyTree.this.root) {
                return this.name;
            }
            return this.getPathWithNameUnchecked();
        }

        private String getPathWithNameUnchecked() {
            char sep = KeyTree.this.options.pathSeparator();
            return this.parent.getPath() + sep + StringUtils.escape(this.name);
        }

        private String indexedName(String name, int listIndex) {
            return name + "[" + listIndex + "]";
        }

        private Node addIndexed(int i) {
            Node child = null;
            Map<String, Object> value = this.getValue();
            if (value != null) {
                if (value instanceof Collection) {
                    int index;
                    int size = ((Collection)((Object)value)).size();
                    if (!this.isList) {
                        this.isList(size);
                    }
                    if (value instanceof List && (index = this.asListIndex(i, size)) >= 0 && index < size) {
                        Object item = ((List)((Object)value)).get(index);
                        String name = item instanceof String || item instanceof Number || item instanceof Boolean ? String.valueOf(item) : null;
                        child = this.add(name);
                    }
                } else {
                    int mapSize;
                    int index;
                    if (value instanceof ConfigurationSection) {
                        value = ((ConfigurationSection)((Object)value)).getValues(false);
                    }
                    if (value instanceof Map && (index = this.asListIndex(i, mapSize = value.size())) >= 0 && index < mapSize) {
                        String key = null;
                        Iterator<String> it = value.keySet().iterator();
                        int j = -1;
                        while (it.hasNext() && ++j <= index) {
                            key = it.next();
                        }
                        if (key != null) {
                            child = this.add(String.valueOf(key));
                        }
                    }
                }
            }
            if (child == null) {
                child = this.add(null);
            }
            child.setElementIndex(i);
            child.checkList();
            return child;
        }

        private int asListIndex(int i, int size) {
            if (i < 0) {
                return size + i;
            }
            return i;
        }

        protected void clearNode() {
            if (this.children != null) {
                this.children.clear();
                this.children = null;
            }
            if (this.indexByName != null) {
                this.indexByName.clear();
                this.indexByName = null;
            }
            if (this.priorityIndex != null) {
                this.priorityIndex.clear();
                this.priorityIndex = null;
            }
            if (this.indexByElementIndex != null) {
                this.indexByElementIndex.clear();
                this.indexByElementIndex = null;
            }
            if (this.parent != null && this.parent.indexByName != null && this.parent.indexByName.get(this.name) == this) {
                this.parent.indexByName.remove(this.name);
                if (this.parent.priorityIndex != null) {
                    this.parent.priorityIndex.remove(this.name);
                }
                if (this.parent.indexByElementIndex != null && this.elementIndex != null) {
                    this.parent.indexByElementIndex.remove(this.elementIndex);
                }
            }
        }

        protected boolean clearIf(Predicate<Node> condition, boolean removeFromParent) {
            if (this.children != null) {
                this.children.removeIf(child -> child.clearIf(condition, false));
            }
            if (!this.hasChildren() && condition.test(this)) {
                this.clearNode();
                if (removeFromParent && this.parent != null) {
                    this.parent.children.remove(this);
                }
                return true;
            }
            return false;
        }

        public boolean clearIf(Predicate<Node> condition) {
            return this.clearIf(condition, true);
        }

        public void clear() {
            this.clearNode();
            if (this.parent != null) {
                this.parent.children.remove(this);
            }
        }

        @Override
        public Iterator<Node> iterator() {
            return this.hasChildren() ? this.children.iterator() : Collections.emptyIterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{");
            builder.append("indent=").append(this.indent).append(", path=").append(StringUtils.wrap(this.getPath())).append(", name=").append(StringUtils.wrap(this.name)).append(", comment=").append(StringUtils.wrap(this.comment)).append(", side=").append(StringUtils.wrap(this.sideComment));
            builder.append(", isList=").append(this.isList);
            if (this.isList) {
                builder.append("(").append(this.listSize).append(")");
            }
            builder.append(", children=");
            if (this.children != null) {
                builder.append('(').append(this.children.size()).append(')');
                builder.append(this.children.stream().map(Node::getName).collect(Collectors.joining(", ", "[", "]")));
            } else {
                builder.append("[]");
            }
            return builder.append('}').toString();
        }
    }
}

