/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.file;

import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.MemoryConfiguration;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.MemoryConfigurationOptions;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.comments.format.CommentFormatter;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.file.FileConfiguration;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FileConfigurationOptions
extends MemoryConfigurationOptions {
    private Charset charset = StandardCharsets.UTF_8;
    private String header = null;
    private boolean copyHeader = true;
    private CommentFormatter headerFormatter;

    protected FileConfigurationOptions(MemoryConfiguration configuration) {
        super(configuration);
    }

    @Override
    public FileConfiguration configuration() {
        return (FileConfiguration)super.configuration();
    }

    @Override
    public FileConfigurationOptions pathSeparator(char value) {
        super.pathSeparator(value);
        return this;
    }

    @Override
    public FileConfigurationOptions copyDefaults(boolean value) {
        super.copyDefaults(value);
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public FileConfigurationOptions charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public boolean isUnicode() {
        return this.charset.name().startsWith("UTF");
    }

    public String header() {
        return this.header;
    }

    public FileConfigurationOptions header(String header) {
        this.header = header;
        return this;
    }

    public boolean copyHeader() {
        return this.copyHeader;
    }

    public FileConfigurationOptions copyHeader(boolean value) {
        this.copyHeader = value;
        return this;
    }

    public CommentFormatter headerFormatter() {
        return this.headerFormatter;
    }

    public FileConfigurationOptions headerFormatter(CommentFormatter headerFormatter) {
        this.headerFormatter = headerFormatter;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileConfigurationOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileConfigurationOptions that = (FileConfigurationOptions)o;
        return this.copyHeader == that.copyHeader && Objects.equals(this.charset, that.charset) && Objects.equals(this.header, that.header) && Objects.equals(this.headerFormatter, that.headerFormatter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.charset, this.header, this.copyHeader, this.headerFormatter);
    }
}

