/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation;

import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.ConfigurationSection;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.comments.CommentType;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.comments.YamlCommentDumper;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.comments.YamlCommentMapper;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.comments.YamlCommentParser;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.file.YamlConfiguration;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.file.YamlConfigurationOptions;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.file.YamlFile;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlConstructor;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlImplementation;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlRepresenter;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.DumperOptions;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.LoaderOptions;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.error.YAMLException;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.resolver.Resolver;
import it.renvins.serverpulse.velocity.libs.simpleyaml.exceptions.InvalidConfigurationException;
import it.renvins.serverpulse.velocity.libs.simpleyaml.utils.SectionUtils;
import it.renvins.serverpulse.velocity.libs.simpleyaml.utils.SupplierIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.Map;

public class SimpleYamlImplementation
extends SnakeYamlImplementation {
    public SimpleYamlImplementation() {
    }

    public SimpleYamlImplementation(LoaderOptions loaderOptions, DumperOptions dumperOptions) {
        super(loaderOptions, dumperOptions);
    }

    public SimpleYamlImplementation(SnakeYamlRepresenter yamlRepresenter) {
        super(yamlRepresenter);
    }

    public SimpleYamlImplementation(SnakeYamlConstructor yamlConstructor, SnakeYamlRepresenter yamlRepresenter) {
        super(yamlConstructor, yamlRepresenter);
    }

    public SimpleYamlImplementation(SnakeYamlConstructor yamlConstructor, SnakeYamlRepresenter yamlRepresenter, Resolver resolver) {
        super(yamlConstructor, yamlRepresenter, resolver);
    }

    @Override
    public void setComment(String path, String comment, CommentType type) {
        if (this.yamlCommentMapper == null) {
            this.options.useComments(true);
            this.yamlCommentMapper = new YamlCommentMapper(this.options);
        }
        this.yamlCommentMapper.setComment(path, comment, type);
    }

    @Override
    public void load(SupplierIO.Reader readerSupplier, ConfigurationSection section) throws IOException, InvalidConfigurationException {
        if (readerSupplier != null) {
            this.load((Reader)readerSupplier.get(), section);
            if (this.options.useComments()) {
                this.parseComments((Reader)readerSupplier.get());
            }
        }
    }

    @Override
    public void load(Reader reader, ConfigurationSection section) throws IOException, InvalidConfigurationException {
        this.configure(this.options);
        if (reader != null && section != null) {
            try {
                Map values2 = (Map)this.getYaml().load(reader);
                if (values2 != null) {
                    SectionUtils.convertMapsToSections(values2, section);
                }
            }
            catch (YAMLException e) {
                throw new InvalidConfigurationException(e);
            }
            catch (ClassCastException e) {
                throw new InvalidConfigurationException("Top level is not a Map.");
            }
            finally {
                reader.close();
            }
        }
    }

    @Override
    public void dump(Writer writer, ConfigurationSection section) throws IOException {
        this.configure(this.options);
        if (this.hasContent(writer, section)) {
            if (this.options.useComments()) {
                YamlCommentDumper commentDumper = new YamlCommentDumper(this.parseComments(), dumper -> super.dumpYaml(dumper, section), writer);
                commentDumper.dump();
            } else {
                super.dumpYaml(writer, section);
            }
        }
    }

    private YamlCommentMapper parseComments() throws IOException {
        File configFile;
        if (this.yamlCommentMapper != null) {
            return this.yamlCommentMapper;
        }
        YamlConfiguration config = this.options.configuration();
        BufferedReader reader = null;
        if (config instanceof YamlFile && (configFile = ((YamlFile)config).getConfigurationFile()) != null) {
            reader = configFile.exists() ? Files.newBufferedReader(configFile.toPath(), this.options.charset()) : null;
        }
        return this.parseComments(reader);
    }

    public YamlCommentMapper parseComments(Reader reader) throws InvalidConfigurationException {
        try {
            if (reader != null) {
                this.yamlCommentMapper = new YamlCommentParser(this.options, reader);
                ((YamlCommentParser)this.yamlCommentMapper).parse();
            } else {
                this.yamlCommentMapper = new YamlCommentMapper(this.options);
            }
            return this.yamlCommentMapper;
        }
        catch (IOException e) {
            throw new InvalidConfigurationException(e);
        }
    }

    @Override
    public void configure(YamlConfigurationOptions options) {
        super.configure(options);
        this.loaderOptions.setProcessComments(false);
        this.dumperOptions.setProcessComments(false);
    }
}

