/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml;

import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.ConfigurationSection;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.api.QuoteValue;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlQuoteValue;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.DumperOptions;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.Node;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.nodes.Tag;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.representer.Represent;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.representer.Representer;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.implementation.snakeyaml.lib.representer.SafeRepresenter;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.serialization.ConfigurationSerializable;
import it.renvins.serverpulse.velocity.libs.simpleyaml.configuration.serialization.ConfigurationSerialization;
import java.util.LinkedHashMap;

public class SnakeYamlRepresenter
extends Representer {
    private final DumperOptions dumperOptions;

    public SnakeYamlRepresenter(DumperOptions dumperOptions) {
        super(dumperOptions);
        this.dumperOptions = dumperOptions;
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        this.multiRepresenters.put(QuoteValue.class, new RepresentQuoteValue());
    }

    protected final DumperOptions getDumperOptions() {
        return this.dumperOptions;
    }

    private final class RepresentQuoteValue
    implements Represent {
        private RepresentQuoteValue() {
        }

        @Override
        public Node representData(Object data) {
            QuoteValue quoteValue = (QuoteValue)data;
            DumperOptions.ScalarStyle quoteScalarStyle = SnakeYamlQuoteValue.getQuoteScalarStyle(quoteValue.getQuoteStyle());
            Object value = quoteValue.getValue();
            if (value == null) {
                return SnakeYamlRepresenter.this.representScalar(Tag.NULL, "", quoteScalarStyle);
            }
            DumperOptions.ScalarStyle defaultScalarStyle = SnakeYamlRepresenter.this.getDefaultScalarStyle();
            SnakeYamlRepresenter.this.setDefaultScalarStyle(quoteScalarStyle);
            Node node = SnakeYamlRepresenter.this.representData(value);
            SnakeYamlRepresenter.this.setDefaultScalarStyle(defaultScalarStyle);
            return node;
        }
    }

    private final class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super(SnakeYamlRepresenter.this);
        }

        @Override
        public Node representData(Object data) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)data;
            LinkedHashMap<String, Object> values2 = new LinkedHashMap<String, Object>();
            values2.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values2.putAll(serializable.serialize());
            return super.representData(values2);
        }
    }

    private final class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super(SnakeYamlRepresenter.this);
        }

        @Override
        public Node representData(Object data) {
            return super.representData(((ConfigurationSection)data).getValues(false));
        }
    }
}

