/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.common.metrics;

import it.renvins.serverpulse.api.data.AsyncMetricsSnapshot;
import it.renvins.serverpulse.api.data.SyncMetricsSnapshot;
import it.renvins.serverpulse.api.data.WorldData;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.metrics.ITPSRetriever;
import it.renvins.serverpulse.api.utils.MemoryUtils;
import it.renvins.serverpulse.common.logger.PulseLogger;
import it.renvins.serverpulse.common.platform.Platform;
import java.util.Map;

public class MetricsCollector {
    private final PulseLogger logger;
    private final Platform platform;
    private final ITPSRetriever tpsRetriever;
    private final IDiskRetriever diskRetriever;
    private final IPingRetriever pingRetriever;

    public MetricsCollector(PulseLogger logger, Platform platform, ITPSRetriever tpsRetriever, IDiskRetriever diskRetriever, IPingRetriever pingRetriever) {
        this.logger = logger;
        this.platform = platform;
        this.tpsRetriever = tpsRetriever;
        this.diskRetriever = diskRetriever;
        this.pingRetriever = pingRetriever;
    }

    public SyncMetricsSnapshot collectSyncSnapshot() {
        if (!this.platform.isPrimaryThread()) {
            this.logger.warning("Attempted to collect sync metrics from a non-primary thread.");
            throw new IllegalStateException("This method must be called on the main server thread.");
        }
        try {
            double[] tps = new double[]{0.0, 0.0, 0.0};
            Map<String, WorldData> worldsData = Map.of();
            int playerCount = this.platform.getOnlinePlayerCount();
            try {
                tps = this.tpsRetriever.getTPS();
                worldsData = this.platform.getWorldsData();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return new SyncMetricsSnapshot(tps, playerCount, worldsData);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error during sync data collection.", e);
            throw new RuntimeException("Sync data collection failed.", e);
        }
    }

    public AsyncMetricsSnapshot collectAsyncSnapshot() {
        long usedHeap = MemoryUtils.getUsedHeapBytes();
        long committedHeap = MemoryUtils.getCommittedHeapBytes();
        long totalDisk = this.diskRetriever.getTotalSpace();
        long usableDisk = this.diskRetriever.getUsableSpace();
        int minPing = this.pingRetriever.getMinPing();
        int maxPing = this.pingRetriever.getMaxPing();
        int avgPing = this.pingRetriever.getAveragePing();
        return new AsyncMetricsSnapshot(usedHeap, committedHeap, totalDisk, usableDisk, minPing, maxPing, avgPing);
    }
}

