/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.simpleyaml.configuration.Configuration;
import org.simpleyaml.configuration.ConfigurationSection;
import org.simpleyaml.configuration.serialization.ConfigurationSerializable;
import org.simpleyaml.utils.NumberConversions;
import org.simpleyaml.utils.StringUtils;
import org.simpleyaml.utils.Validate;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class MemorySection
implements ConfigurationSection {
    protected final Map<String, Object> map = new LinkedHashMap<String, Object>();
    private final Configuration root;
    private final ConfigurationSection parent;
    private final String path;
    private final String fullPath;

    protected MemorySection() {
        if (!(this instanceof Configuration)) {
            throw new IllegalStateException("Cannot construct a root MemorySection when not a Configuration");
        }
        this.path = "";
        this.fullPath = "";
        this.parent = null;
        this.root = (Configuration)((Object)this);
    }

    protected MemorySection(ConfigurationSection parent, String path) {
        Validate.notNull(parent, "Parent cannot be null");
        Validate.notNull(path, "Path cannot be null");
        this.path = path;
        this.parent = parent;
        this.root = parent.getRoot();
        Validate.notNull(this.root, "Path cannot be orphaned");
        this.fullPath = MemorySection.createPath(parent, path);
    }

    public static String createPath(ConfigurationSection section, String key) {
        return MemorySection.createPath(section, key, section == null ? null : section.getRoot());
    }

    public static String createPath(ConfigurationSection section, String key, ConfigurationSection relativeTo) {
        Validate.notNull(section, "Cannot create path without a section");
        Configuration root = section.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create path without a root");
        }
        char separator = root.options().pathSeparator();
        StringBuilder builder = new StringBuilder();
        for (ConfigurationSection parent = section; parent != null && parent != relativeTo; parent = parent.getParent()) {
            if (builder.length() > 0) {
                builder.insert(0, separator);
            }
            builder.insert(0, parent.getName());
        }
        if (key != null && key.length() > 0) {
            if (builder.length() > 0) {
                builder.append(separator);
            }
            builder.append(key);
        }
        return builder.toString();
    }

    @Override
    public Set<String> getKeys(boolean deep) {
        ConfigurationSection defaults;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Configuration root = this.getRoot();
        if (root != null && root.options().copyDefaults() && (defaults = this.getDefaultSection()) != null) {
            result.addAll(defaults.getKeys(deep));
        }
        this.mapChildrenKeys(result, this, deep);
        return result;
    }

    @Override
    public Map<String, Object> getValues(boolean deep) {
        ConfigurationSection defaults;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Configuration root = this.getRoot();
        if (root != null && root.options().copyDefaults() && (defaults = this.getDefaultSection()) != null) {
            result.putAll(defaults.getValues(deep));
        }
        this.mapChildrenValues(result, this, deep);
        return result;
    }

    @Override
    public Map<String, Object> getMapValues(boolean deep) {
        return this.getValues(deep).entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                return new AbstractMap.SimpleEntry<String, Map<String, Object>>(key, ((ConfigurationSection)value).getMapValues(deep));
            }
            return new AbstractMap.SimpleEntry(key, value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public boolean contains(String path) {
        return this.get(path) != null;
    }

    @Override
    public boolean isSet(String path) {
        Configuration root = this.getRoot();
        if (root == null) {
            return false;
        }
        if (root.options().copyDefaults()) {
            return this.contains(path);
        }
        return this.get(path, null) != null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public String getCurrentPath() {
        return this.fullPath;
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public Configuration getRoot() {
        return this.root;
    }

    @Override
    public ConfigurationSection getParent() {
        return this.parent;
    }

    @Override
    public Object get(String path) {
        return this.get(path, this.getDefault(path));
    }

    @Override
    public Object get(String path, Object def) {
        int i2;
        Validate.notNull(path, "Path cannot be null");
        if (path.length() == 0) {
            return this;
        }
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot access section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        Object section = this;
        while ((i1 = StringUtils.firstSeparatorIndex(path, separator, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            if ((section = this.getSection(section, node)) != null) continue;
            return def;
        }
        String key = path.substring(i2);
        return this.getObject(section, key, def);
    }

    @Override
    public void set(String path, Object value) {
        int i2;
        Validate.notNull(path, "Path cannot be null");
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot use section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        Object section = this;
        while ((i1 = StringUtils.firstSeparatorIndex(path, separator, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            Object subSection = this.getSection(section, node);
            if (subSection == null) {
                if (section instanceof ConfigurationSection) {
                    section = ((ConfigurationSection)section).createSection(node);
                    continue;
                }
                return;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        this.setObject(section, key, value);
    }

    @Override
    public ConfigurationSection createSection(String path) {
        int i2;
        Validate.notEmpty(path, "Cannot create section at empty path");
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot create section without a root");
        }
        char separator = root.options().pathSeparator();
        int i1 = -1;
        Object section = this;
        while ((i1 = StringUtils.firstSeparatorIndex(path, separator, i2 = i1 + 1)) != -1) {
            String node = path.substring(i2, i1);
            Object subSection = this.getSection(section, node);
            if (subSection == null) {
                if (section instanceof ConfigurationSection) {
                    section = ((ConfigurationSection)section).createSection(node);
                    continue;
                }
                return null;
            }
            section = subSection;
        }
        String key = path.substring(i2);
        if (section == this) {
            MemorySection result = new MemorySection(this, key);
            this.map.put(key, result);
            return result;
        }
        if (section instanceof ConfigurationSection) {
            return ((ConfigurationSection)section).createSection(key);
        }
        return null;
    }

    private Object getObject(Object section, String node, Object def) {
        Matcher listIndex = StringUtils.LIST_INDEX.matcher(node);
        if (!listIndex.matches()) {
            return this.getObjectRaw(section, node, def);
        }
        Object object = MemorySection.findIndexed(section, listIndex.group(1), Integer.parseInt(listIndex.group(2)));
        return object != null ? object : def;
    }

    private Object getObjectRaw(Object section, String node, Object def) {
        if (section == this) {
            section = this.map;
        }
        if (section instanceof ConfigurationSection) {
            return ((ConfigurationSection)((Object)section)).get(node, def);
        }
        if (section instanceof ConfigurationSerializable) {
            section = ((ConfigurationSerializable)((Object)section)).serialize();
        }
        if (section instanceof Map) {
            return section.getOrDefault(node, def);
        }
        return def;
    }

    private <K, V> void setObject(Object section, K node, V value) {
        Matcher listIndex = StringUtils.LIST_INDEX.matcher((CharSequence)node);
        if (!listIndex.matches()) {
            this.setObjectRaw(section, node, value);
        } else {
            Map<String, Object> it = null;
            String iterableNode = listIndex.group(1);
            if (iterableNode != null && !iterableNode.isEmpty()) {
                it = MemorySection.find(section, iterableNode);
            }
            if (it instanceof MemorySection) {
                it = ((MemorySection)section).map;
            } else if (it instanceof ConfigurationSection) {
                it = ((ConfigurationSection)section).getValues(false);
            }
            if (it != null) {
                int index = Integer.parseInt(listIndex.group(2));
                if (it instanceof Map) {
                    int len = it.size();
                    if ((index = MemorySection.asListIndex(index, len)) >= 0 && index < len) {
                        String key = null;
                        Iterator<String> iterator = it.keySet().iterator();
                        int j = -1;
                        while (iterator.hasNext() && ++j <= index) {
                            key = iterator.next();
                        }
                        this.setObjectRaw(section, key, value);
                    }
                } else if (it instanceof List) {
                    List list = (List)((Object)it);
                    int len = list.size();
                    if (value == null && index == -1 && !list.isEmpty()) {
                        list.remove(len - 1);
                    } else if (value != null && (index == -1 || index == len)) {
                        list.add(value);
                    } else if ((index = MemorySection.asListIndex(index, len)) >= 0 && index < len) {
                        if (value == null) {
                            list.remove(index);
                        } else {
                            list.set(index, value);
                        }
                    }
                } else if (it instanceof Collection && value != null) {
                    Collection collection = (Collection)((Object)it);
                    int len = collection.size();
                    if (index == -1 || index == 0 || index == len) {
                        ((Collection)((Object)it)).add(value);
                    }
                }
            }
        }
    }

    private <K, V> void setObjectRaw(Object section, K key, V value) {
        if (key != null) {
            if (section == this) {
                section = this.map;
            }
            if (section instanceof ConfigurationSection) {
                ((ConfigurationSection)((Object)section)).set(String.valueOf(key), value);
            } else if (section instanceof Map) {
                if (value == null) {
                    section.remove(key);
                } else {
                    section.put((String)key, value);
                }
            }
        }
    }

    private Object getSection(Object parent, String node) {
        Matcher listIndex = StringUtils.LIST_INDEX.matcher(node);
        if (!listIndex.matches()) {
            return MemorySection.findSection(parent, node);
        }
        Object section = MemorySection.findIndexed(parent, listIndex.group(1), Integer.parseInt(listIndex.group(2)));
        return MemorySection.isSection(section) ? section : null;
    }

    private static boolean isSection(Object section) {
        return section instanceof ConfigurationSection || section instanceof ConfigurationSerializable || section instanceof Map;
    }

    private static Object findSection(Object section, String node) {
        if (section instanceof ConfigurationSection) {
            ConfigurationSection configurationSection = (ConfigurationSection)section;
            if ((section = configurationSection.get(node, null)) == null && configurationSection instanceof MemorySection && (section = ((MemorySection)configurationSection).getDefault(node)) instanceof ConfigurationSection) {
                section = configurationSection.createSection(node);
            }
        } else if (section instanceof Map) {
            section = ((Map)section).get(node);
        }
        return MemorySection.isSection(section) ? section : null;
    }

    private static Object find(Object section, String node) {
        Object it = null;
        if (section instanceof ConfigurationSection) {
            ConfigurationSection configurationSection = (ConfigurationSection)section;
            it = configurationSection.get(node, null);
            if (it == null && configurationSection instanceof MemorySection) {
                it = ((MemorySection)configurationSection).getDefault(node);
            }
        } else if (section instanceof Map) {
            it = ((Map)section).get(node);
        }
        return it;
    }

    private static Iterable<?> getIterable(Object section, String node) {
        if (node != null && !node.isEmpty()) {
            section = MemorySection.find(section, node);
        }
        if (section instanceof ConfigurationSection) {
            section = ((ConfigurationSection)((Object)section)).getValues(false).values();
        }
        return section instanceof Iterable ? (Iterable)section : null;
    }

    private static Object findIndexed(Object section, String iterableNode, int index) {
        return MemorySection.getIndexed(MemorySection.getIterable(section, iterableNode), index);
    }

    private static Object getIndexed(Iterable<?> iterable, int index) {
        int len;
        if (iterable == null) {
            return null;
        }
        if (iterable instanceof Collection && ((index = MemorySection.asListIndex(index, len = ((Collection)iterable).size())) < 0 || index >= len)) {
            return null;
        }
        if (iterable instanceof List) {
            return ((List)iterable).get(index);
        }
        Object value = null;
        Iterator<?> it = iterable.iterator();
        if (index >= 0) {
            int i = -1;
            while (it.hasNext()) {
                value = it.next();
                if (++i != index) continue;
            }
            if (i != index) {
                return null;
            }
        } else {
            LinkedList window = new LinkedList();
            int windowSize = -index;
            int filled = 0;
            while (it.hasNext()) {
                window.add(it.next());
                if (filled == windowSize) {
                    window.removeFirst();
                    continue;
                }
                ++filled;
            }
            if (filled < windowSize) {
                return null;
            }
            value = window.getFirst();
        }
        return value;
    }

    private static int asListIndex(int i, int size) {
        if (i < 0) {
            return size + i;
        }
        return i;
    }

    @Override
    public String getString(String path) {
        Object def = this.getDefault(path);
        return this.getString(path, def != null ? def.toString() : null);
    }

    @Override
    public String getString(String path, String def) {
        Object val = this.get(path, def);
        return val != null ? val.toString() : def;
    }

    @Override
    public boolean isString(String path) {
        Object val = this.get(path);
        return val instanceof String;
    }

    @Override
    public int getInt(String path) {
        Object def = this.getDefault(path);
        return this.getInt(path, def instanceof Number ? NumberConversions.toInt(def) : 0);
    }

    @Override
    public int getInt(String path, int def) {
        Object val = this.get(path, def);
        return val instanceof Number ? NumberConversions.toInt(val) : def;
    }

    @Override
    public boolean isInt(String path) {
        Object val = this.get(path);
        return val instanceof Integer;
    }

    @Override
    public boolean getBoolean(String path) {
        Object def = this.getDefault(path);
        return this.getBoolean(path, def instanceof Boolean ? (Boolean)def : false);
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        Object val = this.get(path, def);
        return val instanceof Boolean ? (Boolean)val : def;
    }

    @Override
    public boolean isBoolean(String path) {
        Object val = this.get(path);
        return val instanceof Boolean;
    }

    @Override
    public double getDouble(String path) {
        Object def = this.getDefault(path);
        return this.getDouble(path, def instanceof Number ? NumberConversions.toDouble(def) : 0.0);
    }

    @Override
    public double getDouble(String path, double def) {
        Object val = this.get(path, def);
        return val instanceof Number ? NumberConversions.toDouble(val) : def;
    }

    @Override
    public boolean isDouble(String path) {
        Object val = this.get(path);
        return val instanceof Double;
    }

    @Override
    public long getLong(String path) {
        Object def = this.getDefault(path);
        return this.getLong(path, def instanceof Number ? NumberConversions.toLong(def) : 0L);
    }

    @Override
    public long getLong(String path, long def) {
        Object val = this.get(path, def);
        return val instanceof Number ? NumberConversions.toLong(val) : def;
    }

    @Override
    public boolean isLong(String path) {
        Object val = this.get(path);
        return val instanceof Long;
    }

    @Override
    public List<?> getList(String path) {
        Object def = this.getDefault(path);
        return this.getList(path, def instanceof List ? (List)def : null);
    }

    @Override
    public boolean isList(String path) {
        Object val = this.get(path);
        return val instanceof List;
    }

    @Override
    public List<String> getStringList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object object : list) {
            if (!(object instanceof String) && !this.isPrimitiveWrapper(object)) continue;
            result.add(String.valueOf(object));
        }
        return result;
    }

    @Override
    public List<Integer> getIntegerList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Integer>(0);
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object object : list) {
            if (object instanceof Integer) {
                result.add((Integer)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Integer.valueOf((String)object));
                }
                catch (Exception exception) {}
                continue;
            }
            if (object instanceof Character) {
                result.add(Integer.valueOf(((Character)object).charValue()));
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).intValue());
        }
        return result;
    }

    @Override
    public List<Boolean> getBooleanList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Boolean>(0);
        }
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Object object : list) {
            if (object instanceof Boolean) {
                result.add((Boolean)object);
                continue;
            }
            if (!(object instanceof String)) continue;
            if (Boolean.TRUE.toString().equals(object)) {
                result.add(true);
                continue;
            }
            if (!Boolean.FALSE.toString().equals(object)) continue;
            result.add(false);
        }
        return result;
    }

    @Override
    public List<Double> getDoubleList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Double>(0);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        for (Object object : list) {
            if (object instanceof Double) {
                result.add((Double)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Double.valueOf((String)object));
                }
                catch (Exception exception) {}
                continue;
            }
            if (object instanceof Character) {
                result.add(Double.valueOf(((Character)object).charValue()));
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).doubleValue());
        }
        return result;
    }

    @Override
    public List<Float> getFloatList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Float>(0);
        }
        ArrayList<Float> result = new ArrayList<Float>();
        for (Object object : list) {
            if (object instanceof Float) {
                result.add((Float)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Float.valueOf((String)object));
                }
                catch (Exception exception) {}
                continue;
            }
            if (object instanceof Character) {
                result.add(Float.valueOf(((Character)object).charValue()));
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(Float.valueOf(((Number)object).floatValue()));
        }
        return result;
    }

    @Override
    public List<Long> getLongList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> result = new ArrayList<Long>();
        for (Object object : list) {
            if (object instanceof Long) {
                result.add((Long)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Long.valueOf((String)object));
                }
                catch (Exception exception) {}
                continue;
            }
            if (object instanceof Character) {
                result.add(Long.valueOf(((Character)object).charValue()));
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).longValue());
        }
        return result;
    }

    @Override
    public List<Byte> getByteList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Byte>(0);
        }
        ArrayList<Byte> result = new ArrayList<Byte>();
        for (Object object : list) {
            if (object instanceof Byte) {
                result.add((Byte)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Byte.valueOf((String)object));
                }
                catch (Exception exception) {}
                continue;
            }
            if (object instanceof Character) {
                result.add((byte)((Character)object).charValue());
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).byteValue());
        }
        return result;
    }

    @Override
    public List<Character> getCharacterList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Character>(0);
        }
        ArrayList<Character> result = new ArrayList<Character>();
        for (Object object : list) {
            if (object instanceof Character) {
                result.add((Character)object);
                continue;
            }
            if (object instanceof String) {
                String str = (String)object;
                if (str.length() != 1) continue;
                result.add(Character.valueOf(str.charAt(0)));
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(Character.valueOf((char)((Number)object).intValue()));
        }
        return result;
    }

    @Override
    public List<Short> getShortList(String path) {
        List<?> list = this.getList(path);
        if (list == null) {
            return new ArrayList<Short>(0);
        }
        ArrayList<Short> result = new ArrayList<Short>();
        for (Object object : list) {
            if (object instanceof Short) {
                result.add((Short)object);
                continue;
            }
            if (object instanceof String) {
                try {
                    result.add(Short.valueOf((String)object));
                }
                catch (Exception exception) {}
                continue;
            }
            if (object instanceof Character) {
                result.add((short)((Character)object).charValue());
                continue;
            }
            if (!(object instanceof Number)) continue;
            result.add(((Number)object).shortValue());
        }
        return result;
    }

    @Override
    public List<Map<?, ?>> getMapList(String path) {
        List<?> list = this.getList(path);
        ArrayList result = new ArrayList();
        if (list == null) {
            return result;
        }
        for (Object object : list) {
            if (!(object instanceof Map)) continue;
            result.add((Map)object);
        }
        return result;
    }

    @Override
    public ConfigurationSection getConfigurationSection(String path) {
        Object val = this.get(path, null);
        if (val != null) {
            return val instanceof ConfigurationSection ? (ConfigurationSection)val : null;
        }
        val = this.get(path, this.getDefault(path));
        return val instanceof ConfigurationSection ? this.createSection(path) : null;
    }

    @Override
    public boolean isConfigurationSection(String path) {
        Object val = this.get(path);
        return val instanceof ConfigurationSection;
    }

    @Override
    public ConfigurationSection getDefaultSection() {
        Configuration defaults;
        Configuration root = this.getRoot();
        Configuration configuration = defaults = root == null ? null : root.getDefaults();
        if (defaults != null && defaults.isConfigurationSection(this.getCurrentPath())) {
            return defaults.getConfigurationSection(this.getCurrentPath());
        }
        return null;
    }

    @Override
    public void addDefault(String path, Object value) {
        Validate.notNull(path, "Path cannot be null");
        Configuration root = this.getRoot();
        if (root == null) {
            throw new IllegalStateException("Cannot add default without root");
        }
        if (root == this) {
            throw new UnsupportedOperationException("Unsupported addDefault(String, Object) implementation");
        }
        root.addDefault(MemorySection.createPath(this, path), value);
    }

    @Override
    public ConfigurationSection createSection(String path, Map<?, ?> map) {
        ConfigurationSection section = this.createSection(path);
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                section.createSection(entry.getKey().toString(), (Map)entry.getValue());
                continue;
            }
            section.set(entry.getKey().toString(), entry.getValue());
        }
        return section;
    }

    @Override
    public List<?> getList(String path, List<?> def) {
        List<?> val = this.get(path, def);
        return val instanceof List ? val : def;
    }

    public String toString() {
        Configuration root = this.getRoot();
        return this.getClass().getSimpleName() + "[path='" + this.getCurrentPath() + "', root='" + (root == null ? null : root.getClass().getSimpleName()) + "']";
    }

    protected boolean isPrimitiveWrapper(Object input) {
        return input instanceof Integer || input instanceof Boolean || input instanceof Character || input instanceof Byte || input instanceof Short || input instanceof Double || input instanceof Long || input instanceof Float;
    }

    protected Object getDefault(String path) {
        Validate.notNull(path, "Path cannot be null");
        Configuration root = this.getRoot();
        Configuration defaults = root == null ? null : root.getDefaults();
        return defaults == null ? null : defaults.get(MemorySection.createPath(this, path));
    }

    protected void mapChildrenKeys(Set<String> output, ConfigurationSection section, boolean deep) {
        if (section instanceof MemorySection) {
            MemorySection sec = (MemorySection)section;
            for (Map.Entry<String, Object> entry : sec.map.entrySet()) {
                output.add(MemorySection.createPath(section, entry.getKey(), this));
                if (!deep || !(entry.getValue() instanceof ConfigurationSection)) continue;
                ConfigurationSection subsection = (ConfigurationSection)entry.getValue();
                this.mapChildrenKeys(output, subsection, deep);
            }
        } else {
            Set<String> keys = section.getKeys(deep);
            for (String key : keys) {
                output.add(MemorySection.createPath(section, key, this));
            }
        }
    }

    protected void mapChildrenValues(Map<String, Object> output, ConfigurationSection section, boolean deep) {
        if (section instanceof MemorySection) {
            MemorySection sec = (MemorySection)section;
            for (Map.Entry<String, Object> entry : sec.map.entrySet()) {
                output.put(MemorySection.createPath(section, entry.getKey(), this), entry.getValue());
                if (!deep || !(entry.getValue() instanceof ConfigurationSection)) continue;
                this.mapChildrenValues(output, (ConfigurationSection)entry.getValue(), true);
            }
        } else {
            Map<String, Object> values = section.getValues(deep);
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                output.put(MemorySection.createPath(section, entry.getKey(), this), entry.getValue());
            }
        }
    }
}

