/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bukkit;

import it.renvins.serverpulse.api.ServerPulseProvider;
import it.renvins.serverpulse.api.metrics.IDiskRetriever;
import it.renvins.serverpulse.api.metrics.IPingRetriever;
import it.renvins.serverpulse.api.metrics.ITPSRetriever;
import it.renvins.serverpulse.api.service.IDatabaseService;
import it.renvins.serverpulse.api.service.IMetricsService;
import it.renvins.serverpulse.api.service.Service;
import it.renvins.serverpulse.bukkit.ServerPulseBukkit;
import it.renvins.serverpulse.bukkit.ServerPulseBukkitAPI;
import it.renvins.serverpulse.bukkit.commands.ServerPulseCommand;
import it.renvins.serverpulse.bukkit.config.BukkitConfiguration;
import it.renvins.serverpulse.bukkit.config.BukkitDatabaseConfiguration;
import it.renvins.serverpulse.bukkit.config.BukkitMetricsConfiguration;
import it.renvins.serverpulse.bukkit.logger.BukkitLogger;
import it.renvins.serverpulse.bukkit.metrics.BukkitPingRetriever;
import it.renvins.serverpulse.bukkit.metrics.BukkitTPSRetriever;
import it.renvins.serverpulse.bukkit.metrics.PaperTPSRetriever;
import it.renvins.serverpulse.bukkit.platform.BukkitPlatform;
import it.renvins.serverpulse.bukkit.scheduler.BukkitTaskScheduler;
import it.renvins.serverpulse.common.DatabaseService;
import it.renvins.serverpulse.common.MetricsService;
import it.renvins.serverpulse.common.metrics.DiskRetriever;
import it.renvins.serverpulse.common.platform.Platform;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;

public class ServerPulseBukkitLoader
implements Service {
    private final ServerPulseBukkit plugin;
    public static Logger LOGGER;
    private final BukkitConfiguration config;
    private final Platform platform;
    private final IDatabaseService databaseService;
    private final IMetricsService metricsService;
    private final ITPSRetriever tpsRetriever;
    private final IDiskRetriever diskRetriever;
    private final IPingRetriever pingRetriever;

    public ServerPulseBukkitLoader(ServerPulseBukkit plugin) {
        this.plugin = plugin;
        LOGGER = plugin.getLogger();
        this.config = new BukkitConfiguration(plugin, "config.yml");
        BukkitLogger logger = new BukkitLogger(LOGGER);
        this.platform = new BukkitPlatform(plugin);
        BukkitTaskScheduler taskScheduler = new BukkitTaskScheduler(plugin);
        BukkitDatabaseConfiguration databaseConfiguration = new BukkitDatabaseConfiguration(this.config);
        BukkitMetricsConfiguration metricsConfiguration = new BukkitMetricsConfiguration(this.config);
        this.databaseService = new DatabaseService(logger, this.platform, databaseConfiguration, taskScheduler);
        this.metricsService = new MetricsService(logger, this.platform, metricsConfiguration, taskScheduler);
        this.tpsRetriever = this.isPaper() ? new PaperTPSRetriever() : new BukkitTPSRetriever(plugin);
        this.diskRetriever = new DiskRetriever(plugin.getDataFolder());
        this.pingRetriever = new BukkitPingRetriever();
        LOGGER.info("ServerPulse for Bukkit/Paper initialized - waiting for server starting...");
    }

    @Override
    public void load() {
        LOGGER.info("Loading configuration...");
        this.config.load();
        ServerPulseProvider.register(new ServerPulseBukkitAPI(this.databaseService, this.metricsService, this.tpsRetriever, this.diskRetriever, this.pingRetriever));
        this.databaseService.load();
        if (!this.platform.isEnabled()) {
            return;
        }
        this.metricsService.load();
        if (this.tpsRetriever instanceof BukkitTPSRetriever) {
            LOGGER.info("Starting tick monitoring task...");
            ((BukkitTPSRetriever)this.tpsRetriever).startTickMonitor();
        }
        this.plugin.getCommand("serverpulse").setExecutor((CommandExecutor)new ServerPulseCommand(this.config));
    }

    @Override
    public void unload() {
        this.databaseService.unload();
        this.metricsService.unload();
        this.plugin.getServer().getScheduler().cancelTasks((Plugin)this.plugin);
        ServerPulseProvider.unregister();
    }

    private boolean isPaper() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            LOGGER.info("Server is running Paper (or a Paper fork). Using PaperTPSRetriever.");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Server is not running Paper (or a Paper fork). Using BukkitTPSRetriever.");
            return false;
        }
    }
}

