/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bukkit.config;

import it.renvins.serverpulse.bukkit.ServerPulseBukkit;
import it.renvins.serverpulse.bukkit.ServerPulseBukkitLoader;
import java.io.File;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;

public class BukkitConfiguration {
    private final ServerPulseBukkit plugin;
    private final String name;
    private File file;
    private YamlConfiguration config;

    public BukkitConfiguration(ServerPulseBukkit plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    public void load() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.file = new File(this.plugin.getDataFolder(), this.name);
        if (!this.file.exists()) {
            this.plugin.saveResource(this.name, false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception e) {
            ServerPulseBukkitLoader.LOGGER.log(Level.SEVERE, "Could not save " + this.name + " file", e);
        }
    }

    public boolean reload() {
        if (this.file == null) {
            ServerPulseBukkitLoader.LOGGER.log(Level.SEVERE, "File is null, cannot reload configuration.");
            return false;
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        return true;
    }

    @Generated
    public YamlConfiguration getConfig() {
        return this.config;
    }
}

