/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.bukkit.metrics;

import it.renvins.serverpulse.api.metrics.ITPSRetriever;
import it.renvins.serverpulse.bukkit.ServerPulseBukkit;
import java.util.LinkedList;
import java.util.Queue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BukkitTPSRetriever
implements ITPSRetriever {
    private static final int TICKS_PER_SECOND = 20;
    private static final int ONE_MINUTE_TICKS = 1200;
    private static final int FIVE_MINUTES_TICKS = 6000;
    private static final int FIFTEEN_MINUTES_TICKS = 18000;
    private static final int MAX_HISTORY_SIZE = 18000;
    private final Queue<Long> tickDurations = new LinkedList<Long>();
    private long lastTickTimeNano = -1L;
    private double tps1m = 20.0;
    private double tps5m = 20.0;
    private double tps15m = 20.0;
    private final ServerPulseBukkit plugin;

    public BukkitTPSRetriever(ServerPulseBukkit plugin) {
        this.plugin = plugin;
    }

    @Override
    public double[] getTPS() {
        this.calculateAverages();
        return new double[]{this.tps1m, this.tps5m, this.tps15m};
    }

    public void startTickMonitor() {
        this.lastTickTimeNano = System.nanoTime();
        new BukkitRunnable(){

            public void run() {
                long currentTimeNano = System.nanoTime();
                long elapsedNano = currentTimeNano - BukkitTPSRetriever.this.lastTickTimeNano;
                BukkitTPSRetriever.this.lastTickTimeNano = currentTimeNano;
                BukkitTPSRetriever.this.tickDurations.offer(elapsedNano);
                if (BukkitTPSRetriever.this.tickDurations.size() > 18000) {
                    BukkitTPSRetriever.this.tickDurations.poll();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    private void calculateAverages() {
        double sum1m = 0.0;
        double sum5m = 0.0;
        double sum15m = 0.0;
        int count1m = 0;
        int count5m = 0;
        int count15m = 0;
        int i = 0;
        Object[] durationsArray = this.tickDurations.toArray();
        for (int j = durationsArray.length - 1; j >= 0; --j) {
            if (!(durationsArray[j] instanceof Long)) continue;
            long durationNano = (Long)durationsArray[j];
            if (i < 1200) {
                sum1m += (double)durationNano;
                ++count1m;
            }
            if (i < 6000) {
                sum5m += (double)durationNano;
                ++count5m;
            }
            if (i >= 18000) break;
            sum15m += (double)durationNano;
            ++count15m;
            ++i;
        }
        this.tps1m = this.calculateTPSFromAvgNano(sum1m, count1m);
        this.tps5m = this.calculateTPSFromAvgNano(sum5m, count5m);
        this.tps15m = this.calculateTPSFromAvgNano(sum15m, count15m);
    }

    private double calculateTPSFromAvgNano(double totalNano, int count) {
        if (count == 0) {
            return 20.0;
        }
        double avgTickTimeMillis = totalNano / (double)count / 1000000.0;
        if (avgTickTimeMillis <= 0.0) {
            return 20.0;
        }
        double tps = 1000.0 / avgTickTimeMillis;
        return Math.min(tps, 20.0);
    }
}

