/*
 * Decompiled with CFR 0.152.
 */
package it.renvins.serverpulse.common.config;

import it.renvins.serverpulse.common.logger.PulseLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import lombok.Generated;
import org.simpleyaml.configuration.file.YamlFile;

public class GeneralConfiguration {
    private final PulseLogger logger;
    private final File dataFolder;
    private final String name;
    private YamlFile config;

    public boolean load() {
        try {
            this.createDefaultConfigIfNotExists();
            this.config = new YamlFile(new File(this.dataFolder, this.name));
            this.config.load();
            this.logger.info("Successfully loaded configuration file: " + this.name);
            return true;
        }
        catch (IOException e) {
            this.logger.error("Failed to load configuration file: " + this.name, e);
            return false;
        }
    }

    private void createDefaultConfigIfNotExists() {
        File configFile;
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        if (!(configFile = new File(this.dataFolder, this.name)).exists()) {
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.name);){
                if (inputStream == null) {
                    this.logger.error("Failed to load default configuration file: " + this.name);
                    return;
                }
                Files.copy(inputStream, configFile.toPath(), new CopyOption[0]);
                this.logger.info("Successfully created default configuration file: " + this.name);
            }
            catch (IOException e) {
                this.logger.error("Failed to copy default configuration file: " + this.name, e);
            }
        }
    }

    @Generated
    public GeneralConfiguration(PulseLogger logger, File dataFolder, String name) {
        this.logger = logger;
        this.dataFolder = dataFolder;
        this.name = name;
    }

    @Generated
    public YamlFile getConfig() {
        return this.config;
    }
}

